/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build.model.conversions;

import aQute.bnd.build.model.conversions.Converter;
import aQute.bnd.build.model.conversions.DefaultFormatter;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFormatter<T>
implements Converter<String, Collection<? extends T>> {
    private final String separator;
    private final Converter<String, ? super T> itemFormatter;
    private final String emptyOutput;

    public CollectionFormatter(String separator) {
        this(separator, (String)null);
    }

    public CollectionFormatter(String separator, String emptyOutput) {
        this(separator, new DefaultFormatter(), emptyOutput);
    }

    public CollectionFormatter(String separator, Converter<String, ? super T> itemFormatter) {
        this(separator, itemFormatter, null);
    }

    public CollectionFormatter(String separator, Converter<String, ? super T> itemFormatter, String emptyOutput) {
        this.separator = separator;
        this.itemFormatter = itemFormatter;
        this.emptyOutput = emptyOutput;
    }

    @Override
    public String convert(Collection<? extends T> input) throws IllegalArgumentException {
        String result = null;
        if (input != null) {
            if (input.isEmpty()) {
                result = this.emptyOutput;
            } else {
                StringBuilder buffer = new StringBuilder();
                Iterator<T> iter = input.iterator();
                while (iter.hasNext()) {
                    T item = iter.next();
                    buffer.append(this.itemFormatter.convert(item));
                    if (!iter.hasNext()) continue;
                    buffer.append(this.separator);
                }
                result = buffer.toString();
            }
        }
        return result;
    }
}

