/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.component.DSAnnotations;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.make.Make;
import aQute.bnd.make.MakeBnd;
import aQute.bnd.make.MakeCopy;
import aQute.bnd.make.component.ServiceComponent;
import aQute.bnd.make.metatype.MetatypePlugin;
import aQute.bnd.maven.PomResource;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.CombinedResource;
import aQute.bnd.osgi.CommandResource;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.PreprocessResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.SignerPlugin;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Tree;
import aQute.bnd.service.diff.Type;
import aQute.lib.collections.MultiMap;
import aQute.lib.io.IO;
import aQute.libg.generics.Create;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends Analyzer {
    static Pattern IR_PATTERN = Pattern.compile("[{]?-?@?(?:[^=]+=)?\\s*([^}!]+).*");
    private final DiffPluginImpl differ = new DiffPluginImpl();
    private Pattern xdoNotCopy = null;
    private static final int SPLIT_MERGE_LAST = 1;
    private static final int SPLIT_MERGE_FIRST = 2;
    private static final int SPLIT_ERROR = 3;
    private static final int SPLIT_FIRST = 4;
    private static final int SPLIT_DEFAULT = 0;
    private final List<File> sourcePath = new ArrayList<File>();
    private final Make make = new Make(this);
    boolean firstUse = true;
    private Tree tree;
    static MakeBnd makeBnd = new MakeBnd();
    static MakeCopy makeCopy = new MakeCopy();
    static ServiceComponent serviceComponent = new ServiceComponent();
    static DSAnnotations dsAnnotations = new DSAnnotations();
    static MetatypePlugin metatypePlugin = new MetatypePlugin();

    public Builder(Processor parent) {
        super(parent);
    }

    public Builder() {
    }

    public Jar build() throws Exception {
        this.trace("build", new Object[0]);
        this.init();
        if (Builder.isTrue(this.getProperty("-nobundles"))) {
            return null;
        }
        if (this.getProperty("-conduit") != null) {
            this.error("Specified -conduit but calls build() instead of builds() (might be a programmer error", new Object[0]);
        }
        Jar dot = new Jar("dot");
        try {
            long modified = Long.parseLong(this.getProperty("base.modified"));
            dot.updateModified(modified, "Base modified");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setJar(dot);
        this.doExpand(dot);
        this.doIncludeResources(dot);
        this.doWab(dot);
        Manifest manifest = this.calcManifest();
        String mf = this.getProperty("-manifest");
        if (mf != null) {
            File mff = this.getFile(mf);
            if (mff.isFile()) {
                try {
                    FileInputStream in = new FileInputStream(mff);
                    manifest = new Manifest(in);
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    this.error("-manifest while reading manifest file", e, new Object[0]);
                }
            } else {
                this.error("-manifest, no such file " + mf, new Object[0]);
            }
        }
        if (this.getProperty("-nomanifest") == null) {
            dot.setManifest(manifest);
        } else {
            dot.setDoNotTouchManifest();
        }
        this.addSources(dot);
        if (this.getProperty("-pom") != null) {
            dot.putResource("pom.xml", new PomResource(dot.getManifest()));
        }
        if (!this.isNoBundle()) {
            this.doVerify(dot);
        }
        if (dot.getResources().isEmpty()) {
            this.warning("The JAR is empty: The instructions for the JAR named %s did not cause any content to be included, this is likely wrong", this.getBsn());
        }
        dot.updateModified(this.lastModified(), "Last Modified Processor");
        dot.setName(this.getBsn());
        this.doDigests(dot);
        this.sign(dot);
        this.doSaveManifest(dot);
        this.doDiff(dot);
        this.doBaseline(dot);
        return dot;
    }

    private void doDigests(Jar dot) throws Exception {
        Parameters ps = OSGiHeader.parseHeader(this.getProperty("-digests"));
        if (ps.isEmpty()) {
            return;
        }
        this.trace("digests %s", ps);
        String[] digests = ps.keySet().toArray(new String[ps.size()]);
        dot.setDigestAlgorithms(digests);
    }

    public void init() throws Exception {
        this.begin();
        this.doRequireBnd();
        if (this.getClasspath().size() == 0 && (this.getProperty("Export-Package") != null || this.getProperty("Export-Package") != null || this.getProperty("Private-Package") != null)) {
            this.warning("Classpath is empty. Private-Package and Export-Package can only expand from the classpath when there is one", new Object[0]);
        }
    }

    private Jar doWab(Jar dot) throws Exception {
        String wab = this.getProperty("-wab");
        String wablib = this.getProperty("-wablib");
        if (wab == null && wablib == null) {
            return dot;
        }
        this.trace("wab %s %s", wab, wablib);
        this.setBundleClasspath(Builder.append("WEB-INF/classes", this.getProperty("Bundle-ClassPath")));
        HashSet<String> paths = new HashSet<String>(dot.getResources().keySet());
        for (String path : paths) {
            if (path.indexOf(47) <= 0 || Character.isUpperCase(path.charAt(0))) continue;
            this.trace("wab: moving: %s", path);
            dot.rename(path, "WEB-INF/classes/" + path);
        }
        Parameters clauses = this.parseHeader(this.getProperty("-wablib"));
        for (String key : clauses.keySet()) {
            File f = this.getFile(key);
            this.addWabLib(dot, f);
        }
        this.doIncludeResource(dot, wab);
        return dot;
    }

    private void addWabLib(Jar dot, File f) throws Exception {
        if (f.exists()) {
            Jar jar = new Jar(f);
            jar.setDoNotTouchManifest();
            this.addClose(jar);
            String path = "WEB-INF/lib/" + f.getName();
            dot.putResource(path, new JarResource(jar));
            this.setProperty("Bundle-ClassPath", Builder.append(this.getProperty("Bundle-ClassPath"), path));
            Manifest m = jar.getManifest();
            String cp = m.getMainAttributes().getValue("Class-Path");
            if (cp != null) {
                Collection<String> parts = Builder.split(cp, ",");
                for (String part : parts) {
                    File sub = Builder.getFile(f.getParentFile(), part);
                    if (!sub.exists() || !((Object)sub.getParentFile()).equals(f.getParentFile())) {
                        this.warning("Invalid Class-Path entry %s in %s, must exist and must reside in same directory", sub, f);
                        continue;
                    }
                    this.addWabLib(dot, sub);
                }
            }
        } else {
            this.error("WAB lib does not exist %s", f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveManifest(Jar dot) throws Exception {
        String output = this.getProperty("-savemanifest");
        if (output == null) {
            return;
        }
        File f = this.getFile(output);
        if (f.isDirectory()) {
            f = new File(f, "MANIFEST.MF");
        }
        f.delete();
        File fp = f.getParentFile();
        if (!fp.exists() && !fp.mkdirs()) {
            throw new IOException("Could not create directory " + fp);
        }
        FileOutputStream out = new FileOutputStream(f);
        try {
            Jar.writeManifest(dot.getManifest(), out);
        }
        finally {
            ((OutputStream)out).close();
        }
        this.changedFile(f);
    }

    protected void changedFile(File f) {
    }

    void sign(Jar jar) throws Exception {
        String signing = this.getProperty("-sign");
        if (signing == null) {
            return;
        }
        this.trace("Signing %s, with %s", this.getBsn(), signing);
        List<SignerPlugin> signers = this.getPlugins(SignerPlugin.class);
        Parameters infos = this.parseHeader(signing);
        for (Map.Entry<String, Attrs> entry : infos.entrySet()) {
            for (SignerPlugin signer : signers) {
                signer.sign(this, entry.getKey());
            }
        }
    }

    public boolean hasSources() {
        return Builder.isTrue(this.getProperty("-sources"));
    }

    @Override
    protected Jar getExtra() throws Exception {
        Parameters conditionals = this.getParameters("Conditional-Package");
        if (conditionals.isEmpty()) {
            return null;
        }
        this.trace("do Conditional Package %s", conditionals);
        Instructions instructions = new Instructions(conditionals);
        Collection<Descriptors.PackageRef> referred = instructions.select(this.getReferred().keySet(), false);
        referred.removeAll(this.getContained().keySet());
        Jar jar = new Jar("conditional-import");
        this.addClose(jar);
        block0: for (Descriptors.PackageRef pref : referred) {
            for (Jar cpe : this.getClasspath()) {
                Map<String, Resource> map = cpe.getDirectories().get(pref.getPath());
                if (map == null) continue;
                this.copy(jar, cpe, pref.getPath(), false);
                continue block0;
            }
        }
        if (jar.getDirectories().size() == 0) {
            this.trace("extra dirs %s", jar.getDirectories());
            return null;
        }
        return jar;
    }

    @Override
    public void analyze() throws Exception {
        super.analyze();
        this.cleanupVersion(this.getImports(), null);
        this.cleanupVersion(this.getExports(), this.getVersion());
        String version = this.getProperty("Bundle-Version");
        if (version != null) {
            if ((version = Builder.cleanupVersion(version)).endsWith(".SNAPSHOT")) {
                version = version.replaceAll("SNAPSHOT$", this.getProperty("-snapshot", "SNAPSHOT"));
            }
            this.setProperty("Bundle-Version", version);
        }
    }

    public void cleanupVersion(Packages packages, String defaultVersion) {
        for (Map.Entry<Descriptors.PackageRef, Attrs> entry : packages.entrySet()) {
            Attrs attributes = entry.getValue();
            String v = attributes.get("version");
            if (v == null && defaultVersion != null) {
                if (!Builder.isTrue(this.getProperty("-nodefaultversion"))) {
                    v = defaultVersion;
                    if (this.isPedantic()) {
                        this.warning("Used bundle version %s for exported package %s", v, entry.getKey());
                    }
                } else if (this.isPedantic()) {
                    this.warning("No export version for exported package %s", entry.getKey());
                }
            }
            if (v == null) continue;
            attributes.put("version", Builder.cleanupVersion(v));
        }
    }

    private void addSources(Jar dot) {
        if (!this.hasSources()) {
            return;
        }
        Set packages = Create.set();
        for (Descriptors.TypeRef typeRef : this.getClassspace().keySet()) {
            Descriptors.PackageRef packageRef = typeRef.getPackageRef();
            String sourcePath = typeRef.getSourcePath();
            String packagePath = packageRef.getPath();
            boolean found = false;
            String[] fixed = new String[]{"packageinfo", "package.html", "module-info.java", "package-info.java"};
            for (File root : this.getSourcePath()) {
                File f = Builder.getFile(root, sourcePath);
                if (!f.exists()) continue;
                found = true;
                if (!packages.contains(packageRef)) {
                    packages.add(packageRef);
                    File bdir = Builder.getFile(root, packagePath);
                    for (int j = 0; j < fixed.length; ++j) {
                        File ff = Builder.getFile(bdir, fixed[j]);
                        if (!ff.isFile()) continue;
                        String name = "OSGI-OPT/src/" + packagePath + "/" + fixed[j];
                        dot.putResource(name, new FileResource(ff));
                    }
                }
                if (packageRef.isDefaultPackage()) {
                    System.err.println("Duh?");
                }
                dot.putResource("OSGI-OPT/src/" + sourcePath, new FileResource(f));
            }
            if (!found) {
                for (Jar jar : this.getClasspath()) {
                    Resource resource = jar.getResource(sourcePath);
                    if (resource != null) {
                        dot.putResource("OSGI-OPT/src/" + sourcePath, resource);
                        continue;
                    }
                    resource = jar.getResource("OSGI-OPT/src/" + sourcePath);
                    if (resource == null) continue;
                    dot.putResource("OSGI-OPT/src/" + sourcePath, resource);
                }
            }
            if (!this.getSourcePath().isEmpty()) continue;
            this.warning("Including sources but -sourcepath does not contain any source directories ", new Object[0]);
        }
    }

    public Collection<File> getSourcePath() {
        if (this.firstUse) {
            this.firstUse = false;
            String sp = this.getProperty("-sourcepath");
            if (sp != null) {
                Parameters map = this.parseHeader(sp);
                for (String file : map.keySet()) {
                    if (Builder.isDuplicate(file)) continue;
                    File f = this.getFile(file);
                    if (!f.isDirectory()) {
                        this.error("Adding a sourcepath that is not a directory: " + f, new Object[0]);
                        continue;
                    }
                    this.sourcePath.add(f);
                }
            }
        }
        return this.sourcePath;
    }

    private void doVerify(Jar dot) throws Exception {
        Verifier verifier = new Verifier(this);
        verifier.verify();
        this.getInfo(verifier);
    }

    private void doExpand(Jar dot) {
        Parameters exportedPackage;
        Instructions privateFilter;
        Set<Instruction> unused;
        MultiMap<String, Jar> packages = new MultiMap<String, Jar>();
        for (Jar srce : this.getClasspath()) {
            dot.updateModified(srce.lastModified, srce + " (" + srce.lastModifiedReason + ")");
            for (Map.Entry<String, Map<String, Resource>> e : srce.getDirectories().entrySet()) {
                if (e.getValue() == null) continue;
                packages.add(e.getKey(), srce);
            }
        }
        Parameters privatePackages = this.getPrivatePackage();
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            String h = this.getProperty("-testpackages", "test;presence:=optional");
            privatePackages.putAll(this.parseHeader(h));
        }
        if (!privatePackages.isEmpty() && !(unused = this.doExpand(dot, packages, privateFilter = new Instructions(privatePackages))).isEmpty()) {
            this.warning("Unused Private-Package instructions, no such package(s) on the class path: %s", unused);
        }
        if (!(exportedPackage = this.getExportPackage()).isEmpty()) {
            Instructions exportedFilter = new Instructions(exportedPackage);
            this.doExpand(dot, packages, exportedFilter);
        }
    }

    private Set<Instruction> doExpand(Jar jar, MultiMap<String, Jar> index, Instructions filter) {
        Set<Instruction> unused = Create.set();
        for (Map.Entry<Instruction, Attrs> e : filter.entrySet()) {
            Instruction instruction = e.getKey();
            if (instruction.isDuplicate()) continue;
            Attrs directives = e.getValue();
            Instruction from = new Instruction(directives.get("from:", "*"));
            boolean used = false;
            Iterator entry = index.entrySet().iterator();
            while (entry.hasNext()) {
                List<Jar> providers;
                Map.Entry p = entry.next();
                String directory = (String)p.getKey();
                Descriptors.PackageRef packageRef = this.getPackageRef(directory);
                if (packageRef.isMetaData() && instruction.isAny() || !instruction.matches(packageRef.getFQN())) continue;
                entry.remove();
                if (instruction.isNegated() || (providers = this.filterFrom(from, (List)p.getValue())).isEmpty()) continue;
                int splitStrategy = this.getSplitStrategy(directives.get("-split-package:"));
                this.copyPackage(jar, providers, directory, splitStrategy);
                used = true;
            }
            if (used || Builder.isTrue(directives.get("optional:"))) continue;
            unused.add(instruction);
        }
        return unused;
    }

    private List<Jar> filterFrom(Instruction from, List<Jar> providers) {
        if (from.isAny()) {
            return providers;
        }
        ArrayList<Jar> np = new ArrayList<Jar>();
        for (Jar j : providers) {
            if (!from.matches(j.getName())) continue;
            np.add(j);
        }
        return np;
    }

    private void copyPackage(Jar dest, List<Jar> providers, String path, int splitStrategy) {
        switch (splitStrategy) {
            case 1: {
                for (Jar srce : providers) {
                    this.copy(dest, srce, path, true);
                }
                break;
            }
            case 2: {
                for (Jar srce : providers) {
                    this.copy(dest, srce, path, false);
                }
                break;
            }
            case 3: {
                this.error(this.diagnostic(path, providers), new Object[0]);
                break;
            }
            case 4: {
                this.copy(dest, providers.get(0), path, false);
                break;
            }
            default: {
                if (providers.size() > 1) {
                    this.warning("%s", this.diagnostic(path, providers));
                }
                for (Jar srce : providers) {
                    this.copy(dest, srce, path, false);
                }
            }
        }
    }

    private void copy(Jar dest, Jar srce, String path, boolean overwrite) {
        this.trace("copy d=" + dest + " s=" + srce + " p=" + path, new Object[0]);
        dest.copy(srce, path, overwrite);
        String bndInfoPath = path + "/bnd.info";
        Resource r = dest.getResource(bndInfoPath);
        if (r != null && !(r instanceof PreprocessResource)) {
            this.trace("preprocessing bnd.info", new Object[0]);
            PreprocessResource pp = new PreprocessResource(this, r);
            dest.putResource(bndInfoPath, pp);
        }
        if (this.hasSources()) {
            String srcPath = "OSGI-OPT/src/" + path;
            Map<String, Resource> srcContents = srce.getDirectories().get(srcPath);
            if (srcContents != null) {
                dest.addDirectory(srcContents, overwrite);
            }
        }
    }

    private String diagnostic(String pack, List<Jar> culprits) {
        return "Split package, multiple jars provide the same package:" + pack + "\nUse Import/Export Package directive -split-package:=(merge-first|merge-last|error|first) to get rid of this warning\n" + "Package found in   " + culprits + "\n" + "Class path         " + this.getClasspath();
    }

    private int getSplitStrategy(String type) {
        if (type == null) {
            return 0;
        }
        if (type.equals("merge-last")) {
            return 1;
        }
        if (type.equals("merge-first")) {
            return 2;
        }
        if (type.equals("error")) {
            return 3;
        }
        if (type.equals("first")) {
            return 4;
        }
        this.error("Invalid strategy for split-package: " + type, new Object[0]);
        return 0;
    }

    private Instruction matches(Instructions instructions, String pack, Set<Instruction> unused, String source) {
        for (Map.Entry<Instruction, Attrs> entry : instructions.entrySet()) {
            Instruction f;
            Instruction pattern = entry.getKey();
            String from = entry.getValue().get("from:");
            if (from != null && (!(f = new Instruction(from)).matches(source) || f.isNegated()) || !pattern.matches(pack)) continue;
            if (unused != null) {
                unused.remove(pattern);
            }
            return pattern;
        }
        return null;
    }

    private void doIncludeResources(Jar jar) throws Exception {
        String includes = this.getProperty("Bundle-Includes");
        if (includes == null) {
            includes = this.getProperty("-includeresource");
            if (includes == null || includes.length() == 0) {
                includes = this.getProperty("Include-Resource");
            }
        } else {
            this.warning("Please use -includeresource instead of Bundle-Includes", new Object[0]);
        }
        this.doIncludeResource(jar, includes);
    }

    private void doIncludeResource(Jar jar, String includes) throws Exception {
        Parameters clauses = this.parseHeader(includes);
        this.doIncludeResource(jar, clauses);
    }

    private void doIncludeResource(Jar jar, Parameters clauses) throws ZipException, IOException, Exception {
        for (Map.Entry<String, Attrs> entry : clauses.entrySet()) {
            this.doIncludeResource(jar, entry.getKey(), entry.getValue());
        }
    }

    private void doIncludeResource(Jar jar, String name, Map<String, String> extra) throws ZipException, IOException, Exception {
        boolean preprocess = false;
        boolean absentIsOk = false;
        if (name.startsWith("{") && name.endsWith("}")) {
            preprocess = true;
            name = name.substring(1, name.length() - 1).trim();
        }
        String[] parts = name.split("\\s*=\\s*");
        String source = parts[0];
        String destination = parts[0];
        if (parts.length == 2) {
            source = parts[1];
        }
        if (source.startsWith("-")) {
            source = source.substring(1);
            absentIsOk = true;
        }
        if (source.startsWith("@")) {
            this.extractFromJar(jar, source.substring(1), parts.length == 1 ? "" : destination, absentIsOk);
        } else if (extra.containsKey("cmd")) {
            this.doCommand(jar, source, destination, extra, preprocess, absentIsOk);
        } else if (extra.containsKey("literal")) {
            String literal = extra.get("literal");
            EmbeddedResource r = new EmbeddedResource(literal.getBytes("UTF-8"), 0L);
            String x = extra.get("extra");
            if (x != null) {
                r.setExtra(x);
            }
            jar.putResource(name, r);
        } else {
            File sourceFile = this.getFile(source);
            String destinationPath = parts.length == 1 ? (sourceFile.isDirectory() ? "" : sourceFile.getName()) : parts[0];
            if (sourceFile.isDirectory()) {
                destinationPath = this.doResourceDirectory(jar, extra, preprocess, sourceFile, destinationPath);
                return;
            }
            if (!sourceFile.exists()) {
                if (absentIsOk) {
                    return;
                }
                this.noSuchFile(jar, name, extra, source, destinationPath);
            } else {
                this.copy(jar, destinationPath, sourceFile, preprocess, extra);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommand(Jar jar, String source, String destination, Map<String, String> extra, boolean preprocess, boolean absentIsOk) throws Exception {
        String repeat = extra.get("for");
        if (repeat == null) {
            repeat = source;
        }
        Collection<String> requires = Builder.split(extra.get("requires"));
        long lastModified = 0L;
        for (String required : requires) {
            File file = this.getFile(required);
            if (!file.exists()) {
                this.error("Include-Resource.cmd for %s, requires %s, but no such file %s", source, required, file.getAbsoluteFile());
                continue;
            }
            lastModified = this.findLastModifiedWhileOlder(file, this.lastModified());
        }
        String cmd = extra.get("cmd");
        ArrayList<String> paths = new ArrayList<String>();
        for (String item : Processor.split(repeat)) {
            File f = IO.getFile(item);
            this.traverse(paths, f);
        }
        CombinedResource cr = null;
        if (!destination.contains("${@}")) {
            cr = new CombinedResource();
            cr.lastModified = lastModified;
        }
        this.setProperty("@requires", Builder.join(requires, " "));
        try {
            for (String item : paths) {
                this.setProperty("@", item);
                try {
                    CommandResource cmdresource;
                    String path = this.getReplacer().process(destination);
                    String command = this.getReplacer().process(cmd);
                    File file = this.getFile(item);
                    if (file.exists()) {
                        lastModified = Math.max(lastModified, file.lastModified());
                    }
                    Resource r = cmdresource = new CommandResource(command, this, lastModified, this.getBase());
                    FileResource fr = new FileResource(r);
                    this.addClose(fr);
                    r = fr;
                    if (preprocess) {
                        r = new PreprocessResource(this, r);
                    }
                    if (cr == null) {
                        jar.putResource(path, r);
                        continue;
                    }
                    cr.addResource(r);
                }
                finally {
                    this.unsetProperty("@");
                }
            }
        }
        finally {
            this.unsetProperty("@requires");
        }
        if (cr != null) {
            jar.putResource(destination, cr);
        }
        this.updateModified(lastModified, "Include-Resource: cmd");
    }

    private void traverse(List<String> paths, File item) {
        if (item.isDirectory()) {
            for (File sub : item.listFiles()) {
                this.traverse(paths, sub);
            }
        } else if (item.isFile()) {
            paths.add(item.getAbsolutePath());
        } else {
            paths.add(item.getName());
        }
    }

    private long findLastModifiedWhileOlder(File file, long lastModified) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (child.lastModified() > lastModified) {
                    return child.lastModified();
                }
                long lm = this.findLastModifiedWhileOlder(child, lastModified);
                if (lm <= lastModified) continue;
                return lm;
            }
        }
        return file.lastModified();
    }

    private String doResourceDirectory(Jar jar, Map<String, String> extra, boolean preprocess, File sourceFile, String destinationPath) throws Exception {
        String filter = extra.get("filter:");
        boolean flatten = Builder.isTrue(extra.get("flatten:"));
        boolean recursive = true;
        String directive = extra.get("recursive:");
        if (directive != null) {
            recursive = Builder.isTrue(directive);
        }
        Instruction.Filter iFilter = null;
        iFilter = filter != null ? new Instruction.Filter(new Instruction(filter), recursive, this.getDoNotCopy()) : new Instruction.Filter(null, recursive, this.getDoNotCopy());
        Map<String, File> files = Builder.newMap();
        this.resolveFiles(sourceFile, iFilter, recursive, destinationPath, files, flatten);
        for (Map.Entry<String, File> entry : files.entrySet()) {
            this.copy(jar, entry.getKey(), entry.getValue(), preprocess, extra);
        }
        return destinationPath;
    }

    private void resolveFiles(File dir, FileFilter filter, boolean recursive, String path, Map<String, File> files, boolean flatten) {
        File[] fs;
        if (this.doNotCopy(dir.getName())) {
            return;
        }
        for (File file : fs = dir.listFiles(filter)) {
            if (file.isDirectory()) {
                if (!recursive) continue;
                String nextPath = flatten ? path : Builder.appendPath(path, file.getName());
                this.resolveFiles(file, filter, recursive, nextPath, files, flatten);
                continue;
            }
            String p = Builder.appendPath(path, file.getName());
            if (files.containsKey(p)) {
                this.warning("Include-Resource overwrites entry %s from file %s", p, file);
            }
            files.put(p, file);
        }
        if (fs.length == 0) {
            File empty = new File(dir, "<<EMPTY>>");
            files.put(Builder.appendPath(path, empty.getName()), empty);
        }
    }

    private void noSuchFile(Jar jar, String clause, Map<String, String> extra, String source, String destinationPath) throws Exception {
        Jar src = this.getJarFromName(source, "Include-Resource " + source);
        if (src != null) {
            src.setDoNotTouchManifest();
            JarResource jarResource = new JarResource(src);
            jar.putResource(destinationPath, jarResource);
        } else {
            Resource lastChance = this.make.process(source);
            if (lastChance != null) {
                String x = extra.get("extra");
                if (x != null) {
                    lastChance.setExtra(x);
                }
                jar.putResource(destinationPath, lastChance);
            } else {
                this.error("Input file does not exist: " + source, new Object[0]);
            }
        }
    }

    private void extractFromJar(Jar jar, String source, String destination, boolean absentIsOk) throws ZipException, IOException {
        Jar sub;
        int n = source.lastIndexOf("!/");
        Instruction instr = null;
        if (n > 0) {
            instr = new Instruction(source.substring(n + 2));
            source = source.substring(0, n);
        }
        if ((sub = this.getJarFromName(source, "extract from jar")) == null) {
            if (absentIsOk) {
                return;
            }
            this.error("Can not find JAR file " + source, new Object[0]);
        } else {
            this.addAll(jar, sub, instr, destination);
        }
    }

    public boolean addAll(Jar to, Jar sub, Instruction filter) {
        return this.addAll(to, sub, filter, "");
    }

    public boolean addAll(Jar to, Jar sub, Instruction filter, String destination) {
        boolean dupl = false;
        for (String name : sub.getResources().keySet()) {
            if ("META-INF/MANIFEST.MF".equals(name) || filter != null && filter.matches(name) == filter.isNegated()) continue;
            dupl |= to.putResource(Processor.appendPath(destination, name), sub.getResource(name), true);
        }
        return dupl;
    }

    private void copy(Jar jar, String path, File from, boolean preprocess, Map<String, String> extra) throws Exception {
        if (this.doNotCopy(from.getName())) {
            return;
        }
        if (from.isDirectory()) {
            File[] files = from.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.copy(jar, Builder.appendPath(path, files[i].getName()), files[i], preprocess, extra);
            }
        } else if (from.exists()) {
            String x;
            Resource resource = new FileResource(from);
            if (preprocess) {
                resource = new PreprocessResource(this, resource);
            }
            if ((x = extra.get("extra")) != null) {
                resource.setExtra(x);
            }
            if (path.endsWith("/")) {
                path = path + from.getName();
            }
            jar.putResource(path, resource);
            if (Builder.isTrue(extra.get("lib:"))) {
                this.setProperty("Bundle-ClassPath", Builder.append(this.getProperty("Bundle-ClassPath"), path));
            }
        } else if (from.getName().equals("<<EMPTY>>")) {
            jar.putResource(path, new EmbeddedResource(new byte[0], 0L));
        } else {
            this.error("Input file does not exist: " + from, new Object[0]);
        }
    }

    public void setSourcepath(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addSourcepath(files[i]);
        }
    }

    public void addSourcepath(File cp) {
        if (!cp.exists()) {
            this.warning("File on sourcepath that does not exist: " + cp, new Object[0]);
        }
        this.sourcePath.add(cp);
    }

    @Override
    public void close() {
        super.close();
    }

    public Jar[] builds() throws Exception {
        this.begin();
        String conduit = this.getProperty("-conduit");
        if (conduit != null) {
            Parameters map = this.parseHeader(conduit);
            Jar[] result = new Jar[map.size()];
            int n = 0;
            for (String file : map.keySet()) {
                Jar c = new Jar(this.getFile(file));
                this.addClose(c);
                String name = map.get(file).get("name");
                if (name != null) {
                    c.setName(name);
                }
                result[n++] = c;
            }
            return result;
        }
        ArrayList<Jar> result = new ArrayList<Jar>();
        List<Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            try {
                Jar jar = builder.build();
                jar.setName(builder.getBsn());
                result.add(jar);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error("Sub Building " + builder.getBsn(), e, new Object[0]);
            }
            if (builder == this) continue;
            this.getInfo(builder, builder.getBsn() + ": ");
        }
        return result.toArray(new Jar[result.size()]);
    }

    public List<Builder> getSubBuilders() throws Exception {
        String sub = this.getProperty("-sub");
        if (sub == null || sub.trim().length() == 0 || "<<EMPTY>>".equals(sub)) {
            return Arrays.asList(this);
        }
        ArrayList<Builder> builders = new ArrayList<Builder>();
        if (Builder.isTrue(this.getProperty("-nobundles"))) {
            return builders;
        }
        Parameters subsMap = this.parseHeader(sub);
        Iterator<String> i = subsMap.keySet().iterator();
        while (i.hasNext()) {
            File file = this.getFile(i.next());
            if (!file.isFile() || file.getName().startsWith(".")) continue;
            builders.add(this.getSubBuilder(file));
            i.remove();
        }
        Instructions instructions = new Instructions(subsMap);
        ArrayList<File> members = new ArrayList<File>(Arrays.asList(this.getBase().listFiles()));
        block1: while (members.size() > 0) {
            File file = (File)members.remove(0);
            for (Processor p = this; p != null; p = p.getParent()) {
                if (((Object)file).equals(p.getPropertiesFile())) continue block1;
            }
            for (Instruction instruction : instructions.keySet()) {
                if (!instruction.matches(file.getName())) continue;
                if (instruction.isNegated()) continue block1;
                builders.add(this.getSubBuilder(file));
                continue block1;
            }
        }
        return builders;
    }

    public Builder getSubBuilder(File file) throws Exception {
        Builder builder = this.getSubBuilder();
        if (builder != null) {
            builder.setProperties(file);
            this.addClose(builder);
        }
        return builder;
    }

    public Builder getSubBuilder() throws Exception {
        Builder builder = new Builder(this);
        builder.setBase(this.getBase());
        for (Jar file : this.getClasspath()) {
            builder.addClasspath(file);
        }
        return builder;
    }

    public String _maven_version(String[] args) {
        if (args.length > 2) {
            this.error("${maven_version} macro receives too many arguments " + Arrays.toString(args), new Object[0]);
        } else if (args.length < 2) {
            this.error("${maven_version} macro has no arguments, use ${maven_version;1.2.3-SNAPSHOT}", new Object[0]);
        } else {
            return Builder.cleanupVersion(args[1]);
        }
        return null;
    }

    public String _permissions(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if ("packages".equals(arg) || "all".equals(arg)) {
                for (Descriptors.PackageRef imp : this.getImports().keySet()) {
                    if (imp.isJava()) continue;
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(imp);
                    sb.append("\" \"import\")\r\n");
                }
                for (Descriptors.PackageRef exp : this.getExports().keySet()) {
                    sb.append("(org.osgi.framework.PackagePermission \"");
                    sb.append(exp);
                    sb.append("\" \"export\")\r\n");
                }
                continue;
            }
            if ("admin".equals(arg) || "all".equals(arg)) {
                sb.append("(org.osgi.framework.AdminPermission)");
                continue;
            }
            if ("permissions".equals(arg)) continue;
            this.error("Invalid option in ${permissions}: %s", arg);
        }
        return sb.toString();
    }

    public void removeBundleSpecificHeaders() {
        HashSet<String> set = new HashSet<String>(Arrays.asList(BUNDLE_SPECIFIC_HEADERS));
        this.setForceLocal(set);
    }

    public boolean isInScope(Collection<File> resources) throws Exception {
        Parameters clauses = this.parseHeader(this.getProperty("Export-Package"));
        clauses.putAll(this.parseHeader(this.getProperty("Private-Package")));
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            clauses.putAll(this.parseHeader(this.getProperty("-testpackages", "test;presence:=optional")));
        }
        Collection<String> ir = this.getIncludedResourcePrefixes();
        Instructions instructions = new Instructions(clauses);
        for (File r : resources) {
            String cpEntry = this.getClasspathEntrySuffix(r);
            if (cpEntry != null) {
                if (cpEntry.equals("")) {
                    return true;
                }
                String pack = Descriptors.getPackage(cpEntry);
                Instruction i = this.matches(instructions, pack, null, r.getName());
                if (i != null) {
                    return !i.isNegated();
                }
            }
            String path = r.getAbsolutePath();
            for (String p : ir) {
                if (!path.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<String> getIncludedResourcePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        Parameters includeResource = this.getIncludeResource();
        for (Map.Entry<String, Attrs> p : includeResource.entrySet()) {
            Matcher m;
            if (p.getValue().containsKey("literal") || !(m = IR_PATTERN.matcher(p.getKey())).matches()) continue;
            File f = this.getFile(m.group(1));
            prefixes.add(f.getAbsolutePath());
        }
        return prefixes;
    }

    public String getClasspathEntrySuffix(File resource) throws Exception {
        for (Jar jar : this.getClasspath()) {
            String resourcePath;
            File source = jar.getSource();
            if (source == null) continue;
            String sourcePath = (source = source.getCanonicalFile()).getAbsolutePath();
            if (sourcePath.equals(resourcePath = resource.getAbsolutePath())) {
                return "";
            }
            if (!resourcePath.startsWith(sourcePath)) continue;
            String filePath = resourcePath.substring(sourcePath.length() + 1);
            return filePath.replace(File.separatorChar, '/');
        }
        return null;
    }

    public boolean doNotCopy(String v) {
        return this.getDoNotCopy().matcher(v).matches();
    }

    public Pattern getDoNotCopy() {
        if (this.xdoNotCopy == null) {
            String string = null;
            try {
                string = this.getProperty("-donotcopy", "CVS|\\.svn|\\.git|\\.DS_Store");
                this.xdoNotCopy = Pattern.compile(string);
            }
            catch (Exception e) {
                this.error("Invalid value for %s, value is %s", "-donotcopy", string);
                this.xdoNotCopy = Pattern.compile("CVS|\\.svn|\\.git|\\.DS_Store");
            }
        }
        return this.xdoNotCopy;
    }

    @Override
    protected void setTypeSpecificPlugins(Set<Object> list) {
        list.add(makeBnd);
        list.add(makeCopy);
        list.add(serviceComponent);
        list.add(dsAnnotations);
        list.add(metatypePlugin);
        super.setTypeSpecificPlugins(list);
    }

    public void doDiff(Jar dot) throws Exception {
        Parameters diffs = this.parseHeader(this.getProperty("-diff"));
        if (diffs.isEmpty()) {
            return;
        }
        this.trace("diff %s", diffs);
        if (this.tree == null) {
            this.tree = this.differ.tree(this);
        }
        for (Map.Entry<String, Attrs> entry : diffs.entrySet()) {
            String path = entry.getKey();
            File file = this.getFile(path);
            if (!file.isFile()) {
                this.error("Diffing against %s that is not a file", file);
                continue;
            }
            boolean full = entry.getValue().get("--full") != null;
            boolean warning = entry.getValue().get("--warning") != null;
            Tree other = this.differ.tree(file);
            Diff api = this.tree.diff(other).get("<api>");
            Instructions instructions = new Instructions(entry.getValue().get("--pack"));
            this.trace("diff against %s --full=%s --pack=%s --warning=%s", file, full, instructions);
            for (Diff diff : api.getChildren()) {
                String pname = diff.getName();
                if (diff.getType() != Type.PACKAGE || !instructions.matches(pname) || diff.getDelta() == Delta.UNCHANGED) continue;
                if (!full) {
                    if (warning) {
                        this.warning("Differ %s", diff);
                        continue;
                    }
                    this.error("Differ %s", diff);
                    continue;
                }
                if (warning) {
                    this.warning("Diff found a difference in %s for packages %s", file, instructions);
                } else {
                    this.error("Diff found a difference in %s for packages %s", file, instructions);
                }
                this.show(diff, "", warning);
            }
        }
    }

    private void show(Diff p, String indent, boolean warning) {
        Delta d = p.getDelta();
        if (d == Delta.UNCHANGED) {
            return;
        }
        if (warning) {
            this.warning("%s%s", indent, p);
        } else {
            this.error("%s%s", indent, p);
        }
        indent = indent + " ";
        switch (d) {
            case CHANGED: 
            case MAJOR: 
            case MINOR: 
            case MICRO: {
                break;
            }
            default: {
                return;
            }
        }
        for (Diff diff : p.getChildren()) {
            this.show(diff, indent, warning);
        }
    }

    public void addSourcepath(Collection<File> sourcepath) {
        for (File f : sourcepath) {
            this.addSourcepath(f);
        }
    }

    protected void doBaseline(Jar dot) throws Exception {
    }
}

