/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;

public class AnalyticExpression
implements Expression {
    private List<Column> partitionByColumns;
    private List<OrderByElement> orderByElements;
    private String name;
    private Expression expression;
    private boolean allColumns = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public List<Column> getPartitionByColumns() {
        return this.partitionByColumns;
    }

    public void setPartitionByColumns(List<Column> partitionByColumns) {
        this.partitionByColumns = partitionByColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append(this.name).append("(");
        if (this.expression != null) {
            b.append(this.expression.toString());
        } else if (this.isAllColumns()) {
            b.append("*");
        }
        b.append(") OVER (");
        if (this.partitionByColumns != null && !this.partitionByColumns.isEmpty()) {
            b.append("PARTITION BY ");
            for (i = 0; i < this.partitionByColumns.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.partitionByColumns.get(i).toString());
            }
            b.append(" ");
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            b.append("ORDER BY ");
            for (i = 0; i < this.orderByElements.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.orderByElements.get(i).toString());
            }
        }
        b.append(")");
        return b.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }
}

