/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.util.JavaDetector;
import java.lang.reflect.Method;

public class Reflection
extends SecurityManager {
    private static final Reflection _instance = new Reflection();
    private boolean _useOldReflection = true;

    public static Class<?> getCallerClass(int depth) {
        return _instance._getCallerClass(depth);
    }

    public static int getStackIndex(int oracle, int ibm) {
        return _instance._getStackIndex(new int[]{oracle}, new int[]{ibm});
    }

    public static int getStackIndex(int[] oracle, int[] ibm) {
        return _instance._getStackIndex(oracle, ibm);
    }

    private Reflection() {
        Method[] methods;
        Method[] methodArray = methods = sun.reflect.Reflection.class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.equals("isCallerSensitive")) {
                this._useOldReflection = false;
                break;
            }
            ++n2;
        }
    }

    private Class<?> _getCallerClass(int depth) {
        if (this._useOldReflection) {
            return sun.reflect.Reflection.getCallerClass((int)(depth + 2));
        }
        Class<?>[] callerClasses = this.getClassContext();
        return callerClasses[depth + 1];
    }

    private int _getStackIndex(int[] oracle, int[] ibm) {
        if (oracle.length != ibm.length && oracle.length == 0) {
            throw new IllegalArgumentException("Both arrays must not be empty and have the same length");
        }
        int index = 0;
        index = JavaDetector.isIBM() ? ibm[0] : oracle[0];
        if (oracle.length == 1) {
            return index;
        }
        if (JavaDetector.isJDK7()) {
            index = JavaDetector.isIBM() ? ibm[1] : oracle[1];
        }
        if (oracle.length == 2) {
            return index;
        }
        if (JavaDetector.isJDK7() && !this._useOldReflection) {
            index = JavaDetector.isIBM() ? ibm[2] : oracle[2];
        }
        return index;
    }
}

