/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.Utf8;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public final class IsoTypeReader {
    public static long readUInt32(ByteBuffer bb) {
        long ch1 = IsoTypeReader.readUInt8(bb);
        long ch2 = IsoTypeReader.readUInt8(bb);
        long ch3 = IsoTypeReader.readUInt8(bb);
        long ch4 = IsoTypeReader.readUInt8(bb);
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int readUInt24(ByteBuffer bb) {
        int result = 0;
        result += IsoTypeReader.readUInt16(bb) << 8;
        return result += IsoTypeReader.byte2int(bb.get());
    }

    public static int readUInt16(ByteBuffer bb) {
        int result = 0;
        result += IsoTypeReader.byte2int(bb.get()) << 8;
        return result += IsoTypeReader.byte2int(bb.get());
    }

    public static int readUInt8(ByteBuffer bb) {
        return IsoTypeReader.byte2int(bb.get());
    }

    public static int byte2int(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static String readString(ByteBuffer byteBuffer) {
        byte read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = byteBuffer.get()) != 0) {
            out.write(read);
        }
        return Utf8.convert(out.toByteArray());
    }

    public static String readString(ByteBuffer byteBuffer, int length) {
        byte[] buffer = new byte[length];
        byteBuffer.get(buffer);
        return Utf8.convert(buffer);
    }

    public static long readUInt64(ByteBuffer byteBuffer) {
        long result = 0L;
        if ((result += IsoTypeReader.readUInt32(byteBuffer) << 32) < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return result += IsoTypeReader.readUInt32(byteBuffer);
    }

    public static double readFixedPoint1616(ByteBuffer bb) {
        byte[] bytes = new byte[4];
        bb.get(bytes);
        int result = 0;
        result |= bytes[0] << 24 & 0xFF000000;
        result |= bytes[1] << 16 & 0xFF0000;
        result |= bytes[2] << 8 & 0xFF00;
        return (double)(result |= bytes[3] & 0xFF) / 65536.0;
    }

    public static float readFixedPoint88(ByteBuffer bb) {
        byte[] bytes = new byte[2];
        bb.get(bytes);
        int result = 0;
        result = (short)(result | bytes[0] << 8 & 0xFF00);
        result = (short)(result | bytes[1] & 0xFF);
        return (float)result / 256.0f;
    }

    public static String readIso639(ByteBuffer bb) {
        int bits = IsoTypeReader.readUInt16(bb);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < 3) {
            int c = bits >> (2 - i) * 5 & 0x1F;
            result.append((char)(c + 96));
            ++i;
        }
        return result.toString();
    }

    public static String read4cc(ByteBuffer bb) {
        byte[] b = new byte[4];
        bb.get(b);
        return IsoFile.bytesToFourCC(b);
    }
}

