/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CaseFoldCodeItem;
import org.joni.ArrayCompiler;
import org.joni.BitStatus;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.NodeOptInfo;
import org.joni.OptEnvironment;
import org.joni.Option;
import org.joni.Parser;
import org.joni.ScanEnvironment;
import org.joni.UnsetAddrList;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;

final class Analyser
extends Parser {
    private static final int GET_CHAR_LEN_VARLEN = -1;
    private static final int GET_CHAR_LEN_TOP_ALT_VARLEN = -2;
    private static final int RECURSION_EXIST = 1;
    private static final int RECURSION_INFINITE = 2;
    private static final int FOUND_CALLED_NODE = 1;
    private static final int THRESHOLD_CASE_FOLD_ALT_FOR_EXPANSION = 8;
    private static final int CEC_THRES_NUM_BIG_REPEAT = 512;
    private static final int CEC_INFINITE_NUM = Integer.MAX_VALUE;
    private static final int CEC_IN_INFINITE_REPEAT = 1;
    private static final int CEC_IN_FINITE_REPEAT = 2;
    private static final int CEC_CONT_BIG_REPEAT = 4;
    private static final int IN_ALT = 1;
    private static final int IN_NOT = 2;
    private static final int IN_REPEAT = 4;
    private static final int IN_VAR_REPEAT = 8;
    private static final int EXPAND_STRING_MAX_LENGTH = 100;
    private static final int MAX_NODE_OPT_INFO_REF_COUNT = 5;

    protected Analyser(ScanEnvironment env, byte[] bytes2, int p2, int end2) {
        super(env, bytes2, p2, end2);
    }

    protected final void compile() {
        this.regex.state = -1;
        this.reset();
        this.regex.numMem = 0;
        this.regex.numRepeat = 0;
        this.regex.numNullCheck = 0;
        this.regex.repeatRangeLo = null;
        this.regex.repeatRangeHi = null;
        this.regex.numCombExpCheck = 0;
        this.parse();
        if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.regex.options)) {
            if (this.env.numNamed != this.env.numMem) {
                this.root = this.disableNoNameGroupCapture(this.root);
            } else {
                this.numberedRefCheck(this.root);
            }
        }
        if (this.env.numCall > 0) {
            this.env.unsetAddrList = new UnsetAddrList(this.env.numCall);
            this.setupSubExpCall(this.root);
            this.subexpRecursiveCheckTrav(this.root);
            this.subexpInfRecursiveCheckTrav(this.root);
            this.regex.numCall = this.env.numCall;
        } else {
            this.regex.numCall = 0;
        }
        this.setupTree(this.root, 0);
        this.regex.captureHistory = this.env.captureHistory;
        this.regex.btMemStart = this.env.btMemStart;
        this.regex.btMemEnd = this.env.btMemEnd;
        if (Option.isFindCondition(this.regex.options)) {
            this.regex.btMemEnd = BitStatus.bsAll();
        } else {
            this.regex.btMemEnd = this.env.btMemEnd;
            this.regex.btMemEnd |= this.regex.captureHistory;
        }
        this.regex.clearOptimizeInfo();
        this.setOptimizedInfoFromTree(this.root);
        this.env.memNodes = null;
        new ArrayCompiler(this).compile();
        this.regex.stackPopLevel = this.regex.numRepeat != 0 || this.regex.btMemEnd != 0 ? 2 : (this.regex.btMemStart != 0 ? 1 : 0);
        this.regex.state = 0;
    }

    private Node noNameDisableMap(Node node, int[] map, int[] counter) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    can.setCar(this.noNameDisableMap(can.car, map, counter));
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                Node target;
                QuantifierNode qn = (QuantifierNode)node;
                Node old = target = qn.target;
                target = this.noNameDisableMap(target, map, counter);
                if (target == old) break;
                qn.setTarget(target);
                if (target.getType() != 5) break;
                qn.reduceNestedQuantifier((QuantifierNode)target);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.type == 1) {
                    if (en.isNamedGroup()) {
                        counter[0] = counter[0] + 1;
                        map[en.regNum] = counter[0];
                        en.regNum = counter[0];
                        en.setTarget(this.noNameDisableMap(en.target, map, counter));
                        break;
                    }
                    node = en.target;
                    en.target = null;
                    node = this.noNameDisableMap(node, map, counter);
                    break;
                }
                en.setTarget(this.noNameDisableMap(en.target, map, counter));
                break;
            }
        }
        return node;
    }

    private void renumberByMap(Node node, int[] map) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    this.renumberByMap(can.car, map);
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                this.renumberByMap(((QuantifierNode)node).target, map);
                break;
            }
            case 6: {
                this.renumberByMap(((EncloseNode)node).target, map);
                break;
            }
            case 4: {
                ((BackRefNode)node).renumber(map);
                break;
            }
        }
    }

    protected final void numberedRefCheck(Node node) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    this.numberedRefCheck(can.car);
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                this.numberedRefCheck(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.numberedRefCheck(((EncloseNode)node).target);
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNameRef()) break;
                this.newValueException("numbered backref/call is not allowed. (use name)");
                break;
            }
        }
    }

    protected final Node disableNoNameGroupCapture(Node root) {
        int[] map = new int[this.env.numMem + 1];
        for (int i2 = 1; i2 <= this.env.numMem; ++i2) {
            map[i2] = 0;
        }
        int[] counter = new int[]{0};
        root = this.noNameDisableMap(root, map, counter);
        this.renumberByMap(root, map);
        int pos2 = 1;
        for (int i3 = 1; i3 <= this.env.numMem; ++i3) {
            if (map[i3] <= 0) continue;
            this.env.memNodes[pos2] = this.env.memNodes[i3];
            ++pos2;
        }
        int loc = this.env.captureHistory;
        this.env.captureHistory = BitStatus.bsClear();
        for (int i4 = 1; i4 <= 31; ++i4) {
            if (!BitStatus.bsAt(loc, i4)) continue;
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, map[i4]);
        }
        this.env.numMem = this.env.numNamed;
        this.regex.numMem = this.env.numNamed;
        this.regex.renumberNameTable(map);
        return root;
    }

    private void swap(Node a, Node b) {
        a.swap(b);
        if (this.root == b) {
            this.root = a;
        } else if (this.root == a) {
            this.root = b;
        }
    }

    private int quantifiersMemoryInfo(Node node) {
        int info = 0;
        block0 : switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    int v;
                    if ((v = this.quantifiersMemoryInfo(can.car)) <= info) continue;
                    info = v;
                } while ((can = can.cdr) != null);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    return 3;
                }
                info = this.quantifiersMemoryInfo(cn.target);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.upper == 0) break;
                info = this.quantifiersMemoryInfo(qn.target);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        return 2;
                    }
                    case 2: 
                    case 4: {
                        info = this.quantifiersMemoryInfo(en.target);
                        break block0;
                    }
                }
                break;
            }
        }
        return info;
    }

    private int getMinMatchLength(Node node) {
        int min2 = 0;
        switch (node.getType()) {
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isRecursion()) break;
                if (br.back[0] > this.env.numMem) {
                    this.newValueException("invalid backref number/name");
                }
                min2 = this.getMinMatchLength(this.env.memNodes[br.back[0]]);
                for (int i2 = 1; i2 < br.backNum; ++i2) {
                    int tmin;
                    if (br.back[i2] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    if (min2 <= (tmin = this.getMinMatchLength(this.env.memNodes[br.back[i2]]))) continue;
                    min2 = tmin;
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    EncloseNode en = (EncloseNode)cn.target;
                    if (!en.isMinFixed()) break;
                    min2 = en.minLength;
                    break;
                }
                min2 = this.getMinMatchLength(cn.target);
                break;
            }
            case 8: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    min2 += this.getMinMatchLength(can.car);
                } while ((can = can.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode y = (ConsAltNode)node;
                do {
                    Node x = y.car;
                    int tmin = this.getMinMatchLength(x);
                    if (y == node) {
                        min2 = tmin;
                        continue;
                    }
                    if (min2 <= tmin) continue;
                    min2 = tmin;
                } while ((y = y.cdr) != null);
                break;
            }
            case 0: {
                min2 = ((StringNode)node).length();
                break;
            }
            case 2: {
                min2 = 1;
                break;
            }
            case 1: 
            case 3: {
                min2 = 1;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower <= 0) break;
                min2 = this.getMinMatchLength(qn.target);
                min2 = MinMaxLen.distanceMultiply(min2, qn.lower);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isMinFixed()) {
                            min2 = en.minLength;
                            break;
                        }
                        en.minLength = min2 = this.getMinMatchLength(en.target);
                        en.setMinFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        min2 = this.getMinMatchLength(en.target);
                    }
                }
                break;
            }
        }
        return min2;
    }

    private int getMaxMatchLength(Node node) {
        int max2 = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode ln = (ConsAltNode)node;
                do {
                    int tmax = this.getMaxMatchLength(ln.car);
                    max2 = MinMaxLen.distanceAdd(max2, tmax);
                } while ((ln = ln.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode an = (ConsAltNode)node;
                do {
                    int tmax;
                    if (max2 >= (tmax = this.getMaxMatchLength(an.car))) continue;
                    max2 = tmax;
                } while ((an = an.cdr) != null);
                break;
            }
            case 0: {
                max2 = ((StringNode)node).length();
                break;
            }
            case 2: {
                max2 = this.enc.maxLengthDistance();
                break;
            }
            case 1: 
            case 3: {
                max2 = this.enc.maxLengthDistance();
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isRecursion()) {
                    max2 = Integer.MAX_VALUE;
                    break;
                }
                for (int i2 = 0; i2 < br.backNum; ++i2) {
                    int tmax;
                    if (br.back[i2] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    if (max2 >= (tmax = this.getMaxMatchLength(this.env.memNodes[br.back[i2]]))) continue;
                    max2 = tmax;
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (!cn.isRecursion()) {
                    max2 = this.getMaxMatchLength(cn.target);
                    break;
                }
                max2 = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.upper == 0 || (max2 = this.getMaxMatchLength(qn.target)) == 0) break;
                if (!QuantifierNode.isRepeatInfinite(qn.upper)) {
                    max2 = MinMaxLen.distanceMultiply(max2, qn.upper);
                    break;
                }
                max2 = Integer.MAX_VALUE;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isMaxFixed()) {
                            max2 = en.maxLength;
                            break;
                        }
                        en.maxLength = max2 = this.getMaxMatchLength(en.target);
                        en.setMaxFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        max2 = this.getMaxMatchLength(en.target);
                    }
                }
                break;
            }
        }
        return max2;
    }

    protected final int getCharLengthTree(Node node) {
        return this.getCharLengthTree(node, 0);
    }

    private int getCharLengthTree(Node node, int level2) {
        ++level2;
        int len = 0;
        this.returnCode = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode ln = (ConsAltNode)node;
                do {
                    int tlen = this.getCharLengthTree(ln.car, level2);
                    if (this.returnCode != 0) continue;
                    len = MinMaxLen.distanceAdd(len, tlen);
                } while (this.returnCode == 0 && (ln = ln.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode an = (ConsAltNode)node;
                boolean varLen = false;
                int tlen = this.getCharLengthTree(an.car, level2);
                while (this.returnCode == 0 && (an = an.cdr) != null) {
                    int tlen2 = this.getCharLengthTree(an.car, level2);
                    if (this.returnCode != 0 || tlen == tlen2) continue;
                    varLen = true;
                }
                if (this.returnCode != 0) break;
                if (varLen) {
                    if (level2 == 1) {
                        this.returnCode = -2;
                        break;
                    }
                    this.returnCode = -1;
                    break;
                }
                len = tlen;
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                len = sn.length(this.enc);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower == qn.upper) {
                    int tlen = this.getCharLengthTree(qn.target, level2);
                    if (this.returnCode != 0) break;
                    len = MinMaxLen.distanceMultiply(tlen, qn.lower);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (!cn.isRecursion()) {
                    len = this.getCharLengthTree(cn.target, level2);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 2: {
                len = 1;
            }
            case 1: 
            case 3: {
                len = 1;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isCLenFixed()) {
                            len = en.charLength;
                            break;
                        }
                        len = this.getCharLengthTree(en.target, level2);
                        if (this.returnCode != 0) break;
                        en.charLength = len;
                        en.setCLenFixed();
                        break;
                    }
                    case 2: 
                    case 4: {
                        len = this.getCharLengthTree(en.target, level2);
                    }
                }
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.returnCode = -1;
            }
        }
        return len;
    }

    private boolean isNotIncluded(Node x, Node y) {
        block26: while (true) {
            int yType = y.getType();
            switch (x.getType()) {
                case 2: {
                    Node tmp;
                    switch (yType) {
                        case 2: {
                            CTypeNode cny = (CTypeNode)y;
                            CTypeNode cnx = (CTypeNode)x;
                            return cny.ctype == cnx.ctype && cny.not != cnx.not;
                        }
                        case 1: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                        case 0: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                    }
                    break block26;
                }
                case 1: {
                    Node tmp;
                    CClassNode xc = (CClassNode)x;
                    switch (yType) {
                        case 2: {
                            switch (((CTypeNode)y).ctype) {
                                case 12: {
                                    if (!((CTypeNode)y).not) {
                                        if (xc.mbuf == null && !xc.isNot()) {
                                            for (int i2 = 0; i2 < 256; ++i2) {
                                                if (!xc.bs.at(i2) || !this.enc.isSbWord(i2)) continue;
                                                return false;
                                            }
                                            return true;
                                        }
                                        return false;
                                    }
                                    for (int i3 = 0; i3 < 256; ++i3) {
                                        if (this.enc.isSbWord(i3) || !(!xc.isNot() ? xc.bs.at(i3) : !xc.bs.at(i3))) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            break block26;
                        }
                        case 1: {
                            CClassNode yc = (CClassNode)y;
                            for (int i4 = 0; i4 < 256; ++i4) {
                                boolean v = xc.bs.at(i4);
                                if ((!v || xc.isNot()) && (v || !xc.isNot()) || (!(v = yc.bs.at(i4)) || yc.isNot()) && (v || !yc.isNot())) continue;
                                return false;
                            }
                            return xc.mbuf == null && !xc.isNot() || yc.mbuf == null && !yc.isNot();
                        }
                        case 0: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                    }
                    break block26;
                }
                case 0: {
                    StringNode xs = (StringNode)x;
                    if (xs.length() == 0) break block26;
                    switch (yType) {
                        case 2: {
                            CTypeNode cy = (CTypeNode)y;
                            switch (cy.ctype) {
                                case 12: {
                                    if (this.enc.isMbcWord(xs.bytes, xs.p, xs.end)) {
                                        return cy.not;
                                    }
                                    return !cy.not;
                                }
                            }
                            break block26;
                        }
                        case 1: {
                            CClassNode cc = (CClassNode)y;
                            int code = this.enc.mbcToCode(xs.bytes, xs.p, xs.p + this.enc.maxLength());
                            return !cc.isCodeInCC(this.enc, code);
                        }
                        case 0: {
                            StringNode ys = (StringNode)y;
                            int len = xs.length();
                            if (len > ys.length()) {
                                len = ys.length();
                            }
                            if (xs.isAmbig() || ys.isAmbig()) {
                                return false;
                            }
                            int i5 = 0;
                            int p2 = ys.p;
                            int q = xs.p;
                            while (i5 < len) {
                                if (ys.bytes[p2] != xs.bytes[q]) {
                                    return true;
                                }
                                ++i5;
                                ++p2;
                                ++q;
                            }
                            break block26;
                        }
                    }
                }
            }
            break;
        }
        return false;
    }

    private Node getHeadValueNode(Node node, boolean exact) {
        Node n = null;
        switch (node.getType()) {
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: 
            case 2: {
                if (exact) break;
                n = node;
                break;
            }
            case 8: {
                n = this.getHeadValueNode(((ConsAltNode)node).car, exact);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.end <= sn.p || exact && !sn.isRaw() && Option.isIgnoreCase(this.regex.options)) break;
                n = node;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower <= 0) break;
                if (qn.headExact != null) {
                    n = qn.headExact;
                    break;
                }
                n = this.getHeadValueNode(qn.target, exact);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 2: {
                        int options2 = this.regex.options;
                        this.regex.options = en.option;
                        n = this.getHeadValueNode(en.target, exact);
                        this.regex.options = options2;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n = this.getHeadValueNode(en.target, exact);
                    }
                }
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if (an.type != 1024) break;
                n = this.getHeadValueNode(an.target, exact);
                break;
            }
        }
        return n;
    }

    private boolean checkTypeTree(Node node, int typeMask, int encloseMask, int anchorMask) {
        if ((node.getType2Bit() & typeMask) == 0) {
            return true;
        }
        boolean invalid = false;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                while (!(invalid = this.checkTypeTree(can.car, typeMask, encloseMask, anchorMask)) && (can = can.cdr) != null) {
                }
                break;
            }
            case 5: {
                invalid = this.checkTypeTree(((QuantifierNode)node).target, typeMask, encloseMask, anchorMask);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if ((en.type & encloseMask) == 0) {
                    return true;
                }
                invalid = this.checkTypeTree(en.target, typeMask, encloseMask, anchorMask);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if ((an.type & anchorMask) == 0) {
                    return true;
                }
                if (an.target == null) break;
                invalid = this.checkTypeTree(an.target, typeMask, encloseMask, anchorMask);
                break;
            }
        }
        return invalid;
    }

    private int subexpInfRecursiveCheck(Node node, boolean head) {
        int r = 0;
        switch (node.getType()) {
            case 8: {
                ConsAltNode x = (ConsAltNode)node;
                do {
                    int min2;
                    int ret;
                    if ((ret = this.subexpInfRecursiveCheck(x.car, head)) == 2) {
                        return ret;
                    }
                    r |= ret;
                    if (!head || (min2 = this.getMinMatchLength(x.car)) == 0) continue;
                    head = false;
                } while ((x = x.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                r = 1;
                do {
                    int ret;
                    if ((ret = this.subexpInfRecursiveCheck(can.car, head)) == 2) {
                        return ret;
                    }
                    r &= ret;
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                r = this.subexpInfRecursiveCheck(qn.target, head);
                if (r != 1 || qn.lower != 0) break;
                r = 0;
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpInfRecursiveCheck(an.target, head);
                    }
                }
                break;
            }
            case 10: {
                r = this.subexpInfRecursiveCheck(((CallNode)node).target, head);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isMark2()) {
                    return 0;
                }
                if (en.isMark1()) {
                    return !head ? 1 : 2;
                }
                en.setMark2();
                r = this.subexpInfRecursiveCheck(en.target, head);
                en.clearMark2();
                break;
            }
        }
        return r;
    }

    protected final int subexpInfRecursiveCheckTrav(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                while ((r = this.subexpInfRecursiveCheckTrav(can.car)) == 0 && (can = can.cdr) != null) {
                }
                break;
            }
            case 5: {
                r = this.subexpInfRecursiveCheckTrav(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpInfRecursiveCheckTrav(an.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isRecursion()) {
                    en.setMark1();
                    r = this.subexpInfRecursiveCheck(en.target, true);
                    if (r > 0) {
                        this.newValueException("never ending recursion");
                    }
                    en.clearMark1();
                }
                r = this.subexpInfRecursiveCheckTrav(en.target);
                break;
            }
        }
        return r;
    }

    private int subexpRecursiveCheck(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    r |= this.subexpRecursiveCheck(can.car);
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                r = this.subexpRecursiveCheck(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpRecursiveCheck(an.target);
                    }
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                r = this.subexpRecursiveCheck(cn.target);
                if (r == 0) break;
                cn.setRecursion();
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isMark2()) {
                    return 0;
                }
                if (en.isMark1()) {
                    return 1;
                }
                en.setMark2();
                r = this.subexpRecursiveCheck(en.target);
                en.clearMark2();
                break;
            }
        }
        return r;
    }

    protected final int subexpRecursiveCheckTrav(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    int ret;
                    if ((ret = this.subexpRecursiveCheckTrav(can.car)) != 1) continue;
                    r = 1;
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                r = this.subexpRecursiveCheckTrav(qn.target);
                if (qn.upper != 0 || r != 1) break;
                qn.isRefered = true;
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpRecursiveCheckTrav(an.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (!en.isRecursion() && en.isCalled()) {
                    en.setMark1();
                    r = this.subexpRecursiveCheck(en.target);
                    if (r != 0) {
                        en.setRecursion();
                    }
                    en.clearMark1();
                }
                r = this.subexpRecursiveCheckTrav(en.target);
                if (!en.isCalled()) break;
                r |= 1;
                break;
            }
        }
        return r;
    }

    protected final void setupSubExpCall(Node node) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode ln = (ConsAltNode)node;
                do {
                    this.setupSubExpCall(ln.car);
                } while ((ln = ln.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode can = (ConsAltNode)node;
                do {
                    this.setupSubExpCall(can.car);
                } while ((can = can.cdr) != null);
                break;
            }
            case 5: {
                this.setupSubExpCall(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.setupSubExpCall(((EncloseNode)node).target);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.groupNum != 0) {
                    int gNum = cn.groupNum;
                    if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.env.option)) {
                        this.newValueException("numbered backref/call is not allowed. (use name)");
                    }
                    if (gNum > this.env.numMem) {
                        this.newValueException("undefined group <%n> reference", cn.nameP, cn.nameEnd);
                    }
                    cn.target = this.env.memNodes[cn.groupNum];
                    if (cn.target == null) {
                        this.newValueException("undefined name <%n> reference", cn.nameP, cn.nameEnd);
                    }
                    ((EncloseNode)cn.target).setCalled();
                    this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, cn.groupNum);
                    cn.unsetAddrList = this.env.unsetAddrList;
                    break;
                }
                NameEntry ne = this.regex.nameToGroupNumbers(cn.name, cn.nameP, cn.nameEnd);
                if (ne == null) {
                    this.newValueException("undefined name <%n> reference", cn.nameP, cn.nameEnd);
                    break;
                }
                if (ne.backNum > 1) {
                    this.newValueException("multiplex definition name <%n> call", cn.nameP, cn.nameEnd);
                    break;
                }
                cn.groupNum = ne.backRef1;
                cn.target = this.env.memNodes[cn.groupNum];
                if (cn.target == null) {
                    this.newValueException("undefined name <%n> reference", cn.nameP, cn.nameEnd);
                }
                ((EncloseNode)cn.target).setCalled();
                this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, cn.groupNum);
                cn.unsetAddrList = this.env.unsetAddrList;
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        this.setupSubExpCall(an.target);
                    }
                }
            }
        }
    }

    private void divideLookBehindAlternatives(Node node) {
        AnchorNode an = (AnchorNode)node;
        int anchorType = an.type;
        Node head = an.target;
        Node np = ((ConsAltNode)head).car;
        this.swap(node, head);
        Node tmp = node;
        node = head;
        head = tmp;
        ((ConsAltNode)node).setCar(head);
        ((AnchorNode)head).setTarget(np);
        np = node;
        while ((np = ((ConsAltNode)np).cdr) != null) {
            AnchorNode insert2 = new AnchorNode(anchorType);
            insert2.setTarget(((ConsAltNode)np).car);
            ((ConsAltNode)np).setCar(insert2);
        }
        if (anchorType == 8192) {
            np = node;
            do {
                ((ConsAltNode)np).toListNode();
            } while ((np = ((ConsAltNode)np).cdr) != null);
        }
    }

    private void setupLookBehind(Node node) {
        AnchorNode an = (AnchorNode)node;
        int len = this.getCharLengthTree(an.target);
        switch (this.returnCode) {
            case 0: {
                an.charLength = len;
                break;
            }
            case -1: {
                this.newSyntaxException("invalid pattern in look-behind");
                break;
            }
            case -2: {
                if (this.syntax.differentLengthAltLookBehind()) {
                    this.divideLookBehindAlternatives(node);
                    break;
                }
                this.newSyntaxException("invalid pattern in look-behind");
            }
        }
    }

    private void nextSetup(Node node, Node nextNode) {
        while (true) {
            EncloseNode en;
            int type2;
            if ((type2 = node.getType()) == 5) {
                Node y;
                Node x;
                QuantifierNode qn = (QuantifierNode)node;
                if (!qn.greedy || !QuantifierNode.isRepeatInfinite(qn.upper)) break;
                StringNode n = (StringNode)this.getHeadValueNode(nextNode, true);
                if (n != null && n.bytes[n.p] != 0) {
                    qn.nextHeadExact = n;
                }
                if (qn.lower > 1 || !qn.target.isSimple() || (x = this.getHeadValueNode(qn.target, false)) == null || (y = this.getHeadValueNode(nextNode, false)) == null || !this.isNotIncluded(x, y)) break;
                EncloseNode en2 = new EncloseNode(4);
                en2.setStopBtSimpleRepeat();
                this.swap(node, en2);
                en2.setTarget(node);
                break;
            }
            if (type2 != 6 || !(en = (EncloseNode)node).isMemory()) break;
            node = en.target;
        }
    }

    private void updateStringNodeCaseFold(Node node) {
        StringNode sn = (StringNode)node;
        byte[] sbuf = new byte[sn.length() << 1];
        int sp = 0;
        this.value = sn.p;
        int end2 = sn.end;
        byte[] buf = new byte[18];
        while (this.value < end2) {
            int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, sn.bytes, this, end2, buf);
            for (int i2 = 0; i2 < len; ++i2) {
                if (sp >= sbuf.length) {
                    byte[] tmp = new byte[sbuf.length << 1];
                    System.arraycopy(sbuf, 0, tmp, 0, sbuf.length);
                    sbuf = tmp;
                }
                sbuf[sp++] = buf[i2];
            }
        }
        sn.set(sbuf, 0, sp);
    }

    private Node expandCaseFoldMakeRemString(byte[] bytes2, int p2, int end2) {
        StringNode node = new StringNode(bytes2, p2, end2);
        this.updateStringNodeCaseFold(node);
        node.setAmbig();
        node.setDontGetOptInfo();
        return node;
    }

    private boolean expandCaseFoldStringAlt(int itemNum, CaseFoldCodeItem[] items, byte[] bytes2, int p2, int slen, int end2, Node[] node) {
        ConsAltNode anode;
        ConsAltNode xnode;
        boolean varlen = false;
        for (int i2 = 0; i2 < itemNum; ++i2) {
            if (items[i2].byteLen == slen) continue;
            varlen = true;
            break;
        }
        ConsAltNode varANode = null;
        if (varlen) {
            varANode = ConsAltNode.newAltNode(null, null);
            node[0] = varANode;
            xnode = ConsAltNode.newListNode(null, null);
            varANode.setCar(xnode);
            anode = ConsAltNode.newAltNode(null, null);
            xnode.setCar(anode);
        } else {
            anode = ConsAltNode.newAltNode(null, null);
            node[0] = anode;
        }
        StringNode snode = new StringNode(bytes2, p2, p2 + slen);
        anode.setCar(snode);
        for (int i3 = 0; i3 < itemNum; ++i3) {
            snode = new StringNode();
            for (int j = 0; j < items[i3].codeLen; ++j) {
                snode.ensure(7);
                snode.end += this.enc.codeToMbc(items[i3].code[j], snode.bytes, snode.end);
            }
            ConsAltNode an = ConsAltNode.newAltNode(null, null);
            if (items[i3].byteLen != slen) {
                int q = p2 + items[i3].byteLen;
                if (q < end2) {
                    Node rem = this.expandCaseFoldMakeRemString(bytes2, q, end2);
                    xnode = ConsAltNode.listAdd(null, snode);
                    ConsAltNode.listAdd(xnode, rem);
                    an.setCar(xnode);
                } else {
                    an.setCar(snode);
                }
                varANode.setCdr(an);
                varANode = an;
                continue;
            }
            an.setCar(snode);
            anode.setCdr(an);
            anode = an;
        }
        return varlen;
    }

    private void expandCaseFoldString(Node node) {
        int p2;
        int len;
        StringNode sn = (StringNode)node;
        if (sn.isAmbig() || sn.length() <= 0) {
            return;
        }
        byte[] bytes2 = sn.bytes;
        int end2 = sn.end;
        int altNum = 1;
        Node topRoot = null;
        ConsAltNode root = null;
        Node[] prevNode = new Node[]{null};
        StringNode snode = null;
        for (p2 = sn.p; p2 < end2; p2 += len) {
            boolean r;
            CaseFoldCodeItem[] items = this.enc.caseFoldCodesByString(this.regex.caseFoldFlag, bytes2, p2, end2);
            len = this.enc.length(bytes2, p2, end2);
            if (items.length == 0) {
                if (snode == null) {
                    if (root == null && prevNode[0] != null) {
                        root = ConsAltNode.listAdd(null, prevNode[0]);
                        topRoot = root;
                    }
                    snode = new StringNode();
                    prevNode[0] = snode;
                    if (root != null) {
                        ConsAltNode.listAdd(root, snode);
                    }
                }
                snode.cat(bytes2, p2, p2 + len);
                continue;
            }
            if ((altNum *= items.length + 1) > 8) break;
            if (root == null && prevNode[0] != null) {
                root = ConsAltNode.listAdd(null, prevNode[0]);
                topRoot = root;
            }
            if (r = this.expandCaseFoldStringAlt(items.length, items, bytes2, p2, len, end2, prevNode)) {
                if (root == null) {
                    topRoot = (ConsAltNode)prevNode[0];
                } else {
                    ConsAltNode.listAdd(root, prevNode[0]);
                }
                root = (ConsAltNode)((ConsAltNode)prevNode[0]).car;
            } else if (root != null) {
                ConsAltNode.listAdd(root, prevNode[0]);
            }
            snode = null;
        }
        if (p2 < end2) {
            Node srem = this.expandCaseFoldMakeRemString(bytes2, p2, end2);
            if (prevNode[0] != null && root == null) {
                root = ConsAltNode.listAdd(null, prevNode[0]);
                topRoot = root;
            }
            if (root == null) {
                prevNode[0] = srem;
            } else {
                ConsAltNode.listAdd(root, srem);
            }
        }
        Node xnode = topRoot != null ? topRoot : prevNode[0];
        this.swap(node, xnode);
    }

    protected final int setupCombExpCheck(Node node, int state) {
        int r = state;
        block0 : switch (node.getType()) {
            case 8: {
                ConsAltNode ln = (ConsAltNode)node;
                while ((r = this.setupCombExpCheck(ln.car, r)) >= 0 && (ln = ln.cdr) != null) {
                }
                break;
            }
            case 9: {
                int ret;
                ConsAltNode an = (ConsAltNode)node;
                do {
                    ret = this.setupCombExpCheck(an.car, state);
                    r |= ret;
                } while (ret >= 0 && (an = an.cdr) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                int childState = state;
                int addState = 0;
                if (!QuantifierNode.isRepeatInfinite(qn.upper) && qn.upper > 1) {
                    childState |= 2;
                    if (this.env.backrefedMem == 0 && qn.target.getType() == 6) {
                        EncloseNode en = (EncloseNode)qn.target;
                        if (en.type == 1 && en.target.getType() == 5) {
                            QuantifierNode q = (QuantifierNode)en.target;
                            if (QuantifierNode.isRepeatInfinite(q.upper) && q.greedy == qn.greedy) {
                                int n = qn.upper = qn.lower == 0 ? 1 : qn.lower;
                                if (qn.upper == 1) {
                                    childState = state;
                                }
                            }
                        }
                    }
                }
                if ((state & 2) != 0) {
                    qn.combExpCheckNum = -1;
                } else {
                    int varNum;
                    if (QuantifierNode.isRepeatInfinite(qn.upper)) {
                        varNum = Integer.MAX_VALUE;
                        childState |= 1;
                    } else {
                        varNum = qn.upper - qn.lower;
                    }
                    if (varNum >= 512) {
                        addState |= 4;
                    }
                    if (((state & 1) != 0 && varNum != 0 || (state & 4) != 0 && varNum >= 512) && qn.combExpCheckNum == 0) {
                        ++this.env.numCombExpCheck;
                        qn.combExpCheckNum = this.env.numCombExpCheck;
                        if (this.env.currMaxRegNum > this.env.combExpMaxRegNum) {
                            this.env.combExpMaxRegNum = this.env.currMaxRegNum;
                        }
                    }
                }
                r = this.setupCombExpCheck(qn.target, childState);
                r |= addState;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (this.env.currMaxRegNum < en.regNum) {
                            this.env.currMaxRegNum = en.regNum;
                        }
                        r = this.setupCombExpCheck(en.target, state);
                        break block0;
                    }
                }
                r = this.setupCombExpCheck(en.target, state);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    this.env.hasRecursion = true;
                    break;
                }
                r = this.setupCombExpCheck(cn.target, state);
                break;
            }
        }
        return r;
    }

    protected final void setupTree(Node node, int state) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                Node prev = null;
                do {
                    this.setupTree(lin.car, state);
                    if (prev != null) {
                        this.nextSetup(prev, lin.car);
                    }
                    prev = lin.car;
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                ConsAltNode aln = (ConsAltNode)node;
                do {
                    this.setupTree(aln.car, state | 1);
                } while ((aln = aln.cdr) != null);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (!Option.isIgnoreCase(this.regex.options) || ((StringNode)node).isRaw()) break;
                this.expandCaseFoldString(node);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 10: {
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                for (int i2 = 0; i2 < br.backNum; ++i2) {
                    if (br.back[i2] > this.env.numMem) {
                        this.newValueException("invalid backref number/name");
                    }
                    this.env.backrefedMem = BitStatus.bsOnAt(this.env.backrefedMem, br.back[i2]);
                    this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, br.back[i2]);
                    if (br.isNestLevel()) {
                        this.env.btMemEnd = BitStatus.bsOnAt(this.env.btMemEnd, br.back[i2]);
                    }
                    ((EncloseNode)this.env.memNodes[br.back[i2]]).setMemBackrefed();
                }
                break;
            }
            case 5: {
                int d;
                QuantifierNode qn = (QuantifierNode)node;
                Node target = qn.target;
                if ((state & 4) != 0) {
                    qn.setInRepeat();
                }
                if ((QuantifierNode.isRepeatInfinite(qn.upper) || qn.lower >= 1) && (d = this.getMinMatchLength(target)) == 0) {
                    qn.targetEmptyInfo = 1;
                    int info = this.quantifiersMemoryInfo(target);
                    if (info > 0) {
                        qn.targetEmptyInfo = info;
                    }
                }
                state |= 4;
                if (qn.lower != qn.upper) {
                    state |= 8;
                }
                this.setupTree(target, state);
                if (target.getType() == 0 && !QuantifierNode.isRepeatInfinite(qn.lower) && qn.lower == qn.upper && qn.lower > 1 && qn.lower <= 100) {
                    StringNode sn = (StringNode)target;
                    int len = sn.length();
                    if (len * qn.lower > 100) break;
                    StringNode str = qn.convertToString();
                    int n = qn.lower;
                    for (int i3 = 0; i3 < n; ++i3) {
                        str.cat(sn.bytes, sn.p, sn.end);
                    }
                    break;
                }
                if (!qn.greedy || qn.targetEmptyInfo == 0) break;
                if (target.getType() == 5) {
                    QuantifierNode tqn = (QuantifierNode)target;
                    if (tqn.headExact == null) break;
                    qn.headExact = tqn.headExact;
                    tqn.headExact = null;
                    break;
                }
                qn.headExact = this.getHeadValueNode(qn.target, true);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 2: {
                        int options2 = this.regex.options;
                        this.regex.options = en.option;
                        this.setupTree(en.target, state);
                        this.regex.options = options2;
                        break;
                    }
                    case 1: {
                        if ((state & 0xB) != 0) {
                            this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, en.regNum);
                        }
                        this.setupTree(en.target, state);
                        break;
                    }
                    case 4: {
                        this.setupTree(en.target, state);
                        if (en.target.getType() != 5) break;
                        QuantifierNode tqn = (QuantifierNode)en.target;
                        if (!QuantifierNode.isRepeatInfinite(tqn.upper) || tqn.lower > 1 || !tqn.greedy || !tqn.target.isSimple()) break;
                        en.setStopBtSimpleRepeat();
                    }
                }
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: {
                        this.setupTree(an.target, state);
                        break;
                    }
                    case 2048: {
                        this.setupTree(an.target, state | 2);
                        break;
                    }
                    case 4096: {
                        boolean lbInvalid = this.checkTypeTree(an.target, 2031, 1, 4135);
                        if (lbInvalid) {
                            this.newSyntaxException("invalid pattern in look-behind");
                        }
                        this.setupLookBehind(node);
                        this.setupTree(an.target, state);
                        break;
                    }
                    case 8192: {
                        boolean lbnInvalid = this.checkTypeTree(an.target, 2031, 1, 4135);
                        if (lbnInvalid) {
                            this.newSyntaxException("invalid pattern in look-behind");
                        }
                        this.setupLookBehind(node);
                        this.setupTree(an.target, state | 2);
                    }
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void optimizeNodeLeft(Node node, NodeOptInfo opt, OptEnvironment oenv) {
        opt.clear();
        opt.setBoundNode(oenv.mmd);
        switch (node.getType()) {
            case 8: {
                nenv = new OptEnvironment();
                nopt = new NodeOptInfo();
                nenv.copy(oenv);
                lin = (ConsAltNode)node;
                do {
                    this.optimizeNodeLeft(lin.car, nopt, nenv);
                    nenv.mmd.add(nopt.length);
                    opt.concatLeftNode(nopt, this.enc);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                nopt = new NodeOptInfo();
                aln = (ConsAltNode)node;
                do {
                    this.optimizeNodeLeft(aln.car, nopt, oenv);
                    if (aln == node) {
                        opt.copy(nopt);
                        continue;
                    }
                    opt.altMerge(nopt, oenv);
                } while ((aln = aln.cdr) != null);
                break;
            }
            case 0: {
                sn = (StringNode)node;
                slen = sn.length();
                if (!sn.isAmbig()) {
                    opt.exb.concatStr(sn.bytes, sn.p, sn.end, sn.isRaw(), this.enc);
                    if (slen > 0) {
                        opt.map.addChar(sn.bytes[sn.p], this.enc);
                    }
                    opt.length.set(slen, slen);
                } else {
                    if (sn.isDontGetOptInfo()) {
                        n = sn.length(this.enc);
                        max = this.enc.maxLengthDistance() * n;
                    } else {
                        opt.exb.concatStr(sn.bytes, sn.p, sn.end, sn.isRaw(), this.enc);
                        opt.exb.ignoreCase = true;
                        if (slen > 0) {
                            opt.map.addCharAmb(sn.bytes, sn.p, sn.end, this.enc, oenv.caseFoldFlag);
                        }
                        max = slen;
                    }
                    opt.length.set(slen, max);
                }
                if (opt.exb.length != slen) break;
                opt.exb.reachEnd = true;
                break;
            }
            case 1: {
                cc = (CClassNode)node;
                if (cc.mbuf != null || cc.isNot()) {
                    min = this.enc.minLength();
                    max = this.enc.maxLengthDistance();
                    opt.length.set(min, max);
                    break;
                }
                for (i = 0; i < 256; ++i) {
                    z = cc.bs.at(i);
                    if ((!z || cc.isNot()) && (z || !cc.isNot())) continue;
                    opt.map.addChar((byte)i, this.enc);
                }
                opt.length.set(1, 1);
                break;
            }
            case 2: {
                max = this.enc.maxLengthDistance();
                if (max != 1) ** GOTO lbl81
                min = 1;
                cn = (CTypeNode)node;
                switch (cn.ctype) {
                    case 12: {
                        if (cn.not) {
                            for (i = 0; i < 256; ++i) {
                                if (this.enc.isWord(i)) continue;
                                opt.map.addChar((byte)i, this.enc);
                            }
                        } else {
                            for (i = 0; i < 256; ++i) {
                                if (!this.enc.isWord(i)) continue;
                                opt.map.addChar((byte)i, this.enc);
                            }
                        }
                    }
                }
                ** GOTO lbl82
lbl81:
                // 1 sources

                min = this.enc.minLength();
lbl82:
                // 3 sources

                opt.length.set(min, max);
                break;
            }
            case 3: {
                opt.length.set(this.enc.minLength(), this.enc.maxLengthDistance());
                break;
            }
            case 7: {
                an = (AnchorNode)node;
                switch (an.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: {
                        opt.anchor.add(an.type);
                        break;
                    }
                    case 1024: {
                        nopt = new NodeOptInfo();
                        this.optimizeNodeLeft(an.target, nopt, oenv);
                        if (nopt.exb.length > 0) {
                            opt.expr.copy(nopt.exb);
                        } else if (nopt.exm.length > 0) {
                            opt.expr.copy(nopt.exm);
                        }
                        opt.expr.reachEnd = false;
                        if (nopt.map.value <= 0) break;
                        opt.map.copy(nopt.map);
                        break;
                    }
                }
                break;
            }
            case 4: {
                br = (BackRefNode)node;
                if (br.isRecursion()) {
                    opt.length.set(0, 0x7FFFFFFF);
                    break;
                }
                nodes = oenv.scanEnv.memNodes;
                min = this.getMinMatchLength(nodes[br.back[0]]);
                max = this.getMaxMatchLength(nodes[br.back[0]]);
                for (i = 1; i < br.backNum; ++i) {
                    tmin = this.getMinMatchLength(nodes[br.back[i]]);
                    tmax = this.getMaxMatchLength(nodes[br.back[i]]);
                    if (min > tmin) {
                        min = tmin;
                    }
                    if (max >= tmax) continue;
                    max = tmax;
                }
                opt.length.set(min, max);
                break;
            }
            case 10: {
                cn = (CallNode)node;
                if (cn.isRecursion()) {
                    opt.length.set(0, 0x7FFFFFFF);
                    break;
                }
                safe = oenv.options;
                oenv.options = ((EncloseNode)cn.target).option;
                this.optimizeNodeLeft(cn.target, opt, oenv);
                oenv.options = safe;
                break;
            }
            case 5: {
                nopt = new NodeOptInfo();
                qn = (QuantifierNode)node;
                this.optimizeNodeLeft(qn.target, nopt, oenv);
                if (qn.lower == 0 && QuantifierNode.isRepeatInfinite(qn.upper)) {
                    if (oenv.mmd.max == 0 && qn.target.getType() == 3 && qn.greedy) {
                        if (Option.isMultiline(oenv.options)) {
                            opt.anchor.add(32768);
                        } else {
                            opt.anchor.add(16384);
                        }
                    }
                } else if (qn.lower > 0) {
                    opt.copy(nopt);
                    if (nopt.exb.length > 0 && nopt.exb.reachEnd) {
                        for (i = 1; i < qn.lower && !opt.exb.isFull(); ++i) {
                            opt.exb.concat(nopt.exb, this.enc);
                        }
                        if (i < qn.lower) {
                            opt.exb.reachEnd = false;
                        }
                    }
                    if (qn.lower != qn.upper) {
                        opt.exb.reachEnd = false;
                        opt.exm.reachEnd = false;
                    }
                    if (qn.lower > 1) {
                        opt.exm.reachEnd = false;
                    }
                }
                min = MinMaxLen.distanceMultiply(nopt.length.min, qn.lower);
                max = QuantifierNode.isRepeatInfinite(qn.upper) != false ? (nopt.length.max > 0 ? 0x7FFFFFFF : 0) : MinMaxLen.distanceMultiply(nopt.length.max, qn.upper);
                opt.length.set(min, max);
                break;
            }
            case 6: {
                en = (EncloseNode)node;
                switch (en.type) {
                    case 2: {
                        save = oenv.options;
                        oenv.options = en.option;
                        this.optimizeNodeLeft(en.target, opt, oenv);
                        oenv.options = save;
                        break;
                    }
                    case 1: {
                        if (++en.optCount > 5) {
                            min = 0;
                            max = 0x7FFFFFFF;
                            if (en.isMinFixed()) {
                                min = en.minLength;
                            }
                            if (en.isMaxFixed()) {
                                max = en.maxLength;
                            }
                            opt.length.set(min, max);
                            break;
                        }
                        this.optimizeNodeLeft(en.target, opt, oenv);
                        if (!opt.anchor.isSet(49152) || !BitStatus.bsAt(oenv.scanEnv.backrefedMem, en.regNum)) break;
                        opt.anchor.remove(49152);
                        break;
                    }
                    case 4: {
                        this.optimizeNodeLeft(en.target, opt, oenv);
                    }
                }
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void setOptimizedInfoFromTree(Node node) {
        NodeOptInfo opt = new NodeOptInfo();
        OptEnvironment oenv = new OptEnvironment();
        oenv.enc = this.regex.enc;
        oenv.options = this.regex.options;
        oenv.caseFoldFlag = this.regex.caseFoldFlag;
        oenv.scanEnv = this.env;
        oenv.mmd.clear();
        this.optimizeNodeLeft(node, opt, oenv);
        this.regex.anchor = opt.anchor.leftAnchor & 0xC005;
        this.regex.anchor |= opt.anchor.rightAnchor & 0x18;
        if ((this.regex.anchor & 0x18) != 0) {
            this.regex.anchorDmin = opt.length.min;
            this.regex.anchorDmax = opt.length.max;
        }
        if (opt.exb.length > 0 || opt.exm.length > 0) {
            opt.exb.select(opt.exm, this.enc);
            if (opt.map.value > 0 && opt.exb.compare(opt.map) > 0) {
                this.regex.setOptimizeMapInfo(opt.map);
                this.regex.setSubAnchor(opt.map.anchor);
            } else {
                this.regex.setExactInfo(opt.exb);
                this.regex.setSubAnchor(opt.exb.anchor);
            }
        } else if (opt.map.value > 0) {
            this.regex.setOptimizeMapInfo(opt.map);
            this.regex.setSubAnchor(opt.map.anchor);
        } else {
            this.regex.subAnchor |= opt.anchor.leftAnchor & 2;
            if (opt.length.max == 0) {
                this.regex.subAnchor |= opt.anchor.rightAnchor & 0x20;
            }
        }
    }
}

