/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Option;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SearchAlgorithm;

public abstract class Matcher
extends IntHolder {
    protected final Regex regex;
    protected final Encoding enc;
    protected final byte[] bytes;
    protected final int str;
    protected final int end;
    protected int msaStart;
    protected int msaOptions;
    protected final Region msaRegion;
    protected int msaBestLen;
    protected int msaBestS;
    protected int msaBegin;
    protected int msaEnd;
    int low;
    int high;

    public Matcher(Regex regex, byte[] bytes2) {
        this(regex, bytes2, 0, bytes2.length);
    }

    public Matcher(Regex regex, byte[] bytes2, int p2, int end2) {
        this.regex = regex;
        this.enc = regex.enc;
        this.bytes = bytes2;
        this.str = p2;
        this.end = end2;
        this.msaRegion = regex.numMem == 0 ? null : new Region(regex.numMem + 1);
    }

    protected abstract int matchAt(int var1, int var2, int var3);

    protected abstract void stateCheckBuffInit(int var1, int var2, int var3);

    protected abstract void stateCheckBuffClear();

    public final Region getRegion() {
        return this.msaRegion;
    }

    public final Region getEagerRegion() {
        return this.msaRegion != null ? this.msaRegion : new Region(this.msaBegin, this.msaEnd);
    }

    public final int getBegin() {
        return this.msaBegin;
    }

    public final int getEnd() {
        return this.msaEnd;
    }

    protected final void msaInit(int option, int start2) {
        this.msaOptions = option;
        this.msaStart = start2;
        this.msaBestLen = -1;
    }

    public final int match(int at2, int range, int option) {
        this.msaInit(option, at2);
        int prev = this.enc.prevCharHead(this.bytes, this.str, at2, this.end);
        return this.matchAt(range, at2, prev);
    }

    private boolean forwardSearchRange(byte[] bytes2, int str, int end2, int s2, int range, IntHolder lowPrev) {
        int p2;
        int pprev = -1;
        if (this.regex.dMin > 0) {
            if (this.enc.isSingleByte()) {
                p2 += this.regex.dMin;
            } else {
                int q = p2 + this.regex.dMin;
                for (p2 = s2; p2 < q; p2 += this.enc.length(bytes2, p2, end2)) {
                }
            }
        }
        block5: while ((p2 = this.regex.searchAlgorithm.search(this.regex, bytes2, p2, end2, range)) != -1 && p2 < range) {
            if (p2 - this.regex.dMin < s2) {
                pprev = p2;
                p2 += this.enc.length(bytes2, p2, end2);
                continue;
            }
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p2 == str || this.enc.isNewLine(bytes2, prev = this.enc.prevCharHead(bytes2, pprev != -1 ? pprev : str, p2, end2), end2)) break;
                        pprev = p2;
                        p2 += this.enc.length(bytes2, p2, end2);
                        continue block5;
                    }
                    case 32: {
                        if (p2 == end2 || this.enc.isNewLine(bytes2, p2, end2)) break;
                        pprev = p2;
                        p2 += this.enc.length(bytes2, p2, end2);
                        continue block5;
                    }
                }
            }
            if (this.regex.dMax == 0) {
                this.low = p2;
                if (lowPrev != null) {
                    lowPrev.value = this.low > s2 ? this.enc.prevCharHead(bytes2, s2, p2, end2) : this.enc.prevCharHead(bytes2, pprev != -1 ? pprev : str, p2, end2);
                }
            } else if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p2 - this.regex.dMax;
                if (this.low > s2) {
                    this.low = this.enc.rightAdjustCharHeadWithPrev(bytes2, s2, this.low, end2, lowPrev);
                    if (lowPrev != null && lowPrev.value == -1) {
                        lowPrev.value = this.enc.prevCharHead(bytes2, pprev != -1 ? pprev : s2, this.low, end2);
                    }
                } else if (lowPrev != null) {
                    lowPrev.value = this.enc.prevCharHead(bytes2, pprev != -1 ? pprev : str, this.low, end2);
                }
            }
            this.high = p2 - this.regex.dMin;
            return true;
        }
        return false;
    }

    private boolean backwardSearchRange(byte[] bytes2, int str, int end2, int s2, int range, int adjrange) {
        range += this.regex.dMin;
        int p2 = s2;
        block4: while ((p2 = this.regex.searchAlgorithm.searchBackward(this.regex, bytes2, range, adjrange, end2, p2, s2, range)) != -1) {
            if (this.regex.subAnchor != 0) {
                switch (this.regex.subAnchor) {
                    case 2: {
                        int prev;
                        if (p2 == str || this.enc.isNewLine(bytes2, prev = this.enc.prevCharHead(bytes2, str, p2, end2), end2)) break;
                        p2 = prev;
                        continue block4;
                    }
                    case 32: {
                        if (p2 == end2 || this.enc.isNewLine(bytes2, p2, end2)) break;
                        if ((p2 = this.enc.prevCharHead(bytes2, adjrange, p2, end2)) != -1) continue block4;
                        return false;
                    }
                }
            }
            if (this.regex.dMax != Integer.MAX_VALUE) {
                this.low = p2 - this.regex.dMax;
                this.high = p2 - this.regex.dMin;
                this.high = this.enc.rightAdjustCharHead(bytes2, adjrange, this.high, end2);
            }
            return true;
        }
        return false;
    }

    private boolean matchCheck(int upperRange, int s2, int prev) {
        return this.matchAt(this.end, s2, prev) != -1 && !Option.isFindLongest(this.regex.options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int search(int start2, int range, int option) {
        int prev;
        int origStart = start2;
        int origRange = range;
        if (start2 > this.end || start2 < this.str) {
            return -1;
        }
        if (this.regex.anchor != 0 && this.str < this.end) {
            int minSemiEnd;
            int maxSemiEnd;
            if ((this.regex.anchor & 4) != 0) {
                range = range > start2 ? start2 + 1 : start2;
            } else if ((this.regex.anchor & 1) != 0) {
                if (range > start2) {
                    if (start2 != this.str) {
                        return -1;
                    }
                    range = this.str + 1;
                } else {
                    if (range > this.str) return -1;
                    start2 = this.str;
                    range = this.str;
                }
            } else if ((this.regex.anchor & 8) != 0) {
                maxSemiEnd = this.end;
                minSemiEnd = maxSemiEnd;
                if (this.endBuf(start2, range, minSemiEnd, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x10) != 0) {
                int preEnd = this.enc.stepBack(this.bytes, this.str, this.end, this.end, 1);
                maxSemiEnd = this.end;
                if (this.enc.isNewLine(this.bytes, preEnd, this.end) ? (minSemiEnd = preEnd) > this.str && start2 <= minSemiEnd && this.endBuf(start2, range, minSemiEnd, maxSemiEnd) : this.endBuf(start2, range, minSemiEnd = this.end, maxSemiEnd)) {
                    return -1;
                }
            } else if ((this.regex.anchor & 0x8000) != 0) {
                range = range > start2 ? start2 + 1 : start2;
            }
        } else if (this.str == this.end) {
            if (this.regex.thresholdLength != 0) return -1;
            int s2 = start2 = this.str;
            int prev2 = -1;
            this.msaInit(option, start2);
            if (!this.matchCheck(this.end, s2, prev2)) return this.mismatch();
            return this.match(s2);
        }
        this.msaInit(option, origStart);
        int s3 = start2;
        if (range > start2) {
            int prev3 = s3 > this.str ? this.enc.prevCharHead(this.bytes, this.str, s3, this.end) : 0;
            if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
                int schRange = range;
                if (this.regex.dMax != 0) {
                    if (this.regex.dMax == Integer.MAX_VALUE) {
                        schRange = this.end;
                    } else if ((schRange += this.regex.dMax) > this.end) {
                        schRange = this.end;
                    }
                }
                if (this.end - start2 < this.regex.thresholdLength) {
                    return this.mismatch();
                }
                if (this.regex.dMax != Integer.MAX_VALUE) {
                    do {
                        if (!this.forwardSearchRange(this.bytes, this.str, this.end, s3, schRange, this)) {
                            return this.mismatch();
                        }
                        if (s3 < this.low) {
                            s3 = this.low;
                            prev3 = this.value;
                        }
                        while (s3 <= this.high) {
                            if (this.matchCheck(origRange, s3, prev3)) {
                                return this.match(s3);
                            }
                            prev3 = s3;
                            s3 += this.enc.length(this.bytes, s3, this.end);
                        }
                    } while (s3 < range);
                    return this.mismatch();
                }
                if (!this.forwardSearchRange(this.bytes, this.str, this.end, s3, schRange, null)) {
                    return this.mismatch();
                }
                if ((this.regex.anchor & 0x4000) != 0) {
                    do {
                        if (this.matchCheck(origRange, s3, prev3)) {
                            return this.match(s3);
                        }
                        prev3 = s3;
                    } while ((s3 += this.enc.length(this.bytes, s3, this.end)) < range);
                    return this.mismatch();
                }
            }
            do {
                if (this.matchCheck(origRange, s3, prev3)) {
                    return this.match(s3);
                }
                prev3 = s3;
            } while ((s3 += this.enc.length(this.bytes, s3, this.end)) < range);
            if (s3 != range || !this.matchCheck(origRange, s3, prev3)) return this.mismatch();
            return this.match(s3);
        }
        if (this.regex.searchAlgorithm != SearchAlgorithm.NONE) {
            int schStart;
            int adjrange = range < this.end ? this.enc.leftAdjustCharHead(this.bytes, this.str, range, this.end) : this.end;
            if (this.regex.dMax != Integer.MAX_VALUE && this.end - range >= this.regex.thresholdLength) {
                do {
                    if ((schStart = s3 + this.regex.dMax) > this.end) {
                        schStart = this.end;
                    }
                    if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                        return this.mismatch();
                    }
                    if (s3 > this.high) {
                        s3 = this.high;
                    }
                    while (s3 != -1 && s3 >= this.low) {
                        int prev4 = this.enc.prevCharHead(this.bytes, this.str, s3, this.end);
                        if (this.matchCheck(origStart, s3, prev4)) {
                            return this.match(s3);
                        }
                        s3 = prev4;
                    }
                } while (s3 >= range);
                return this.mismatch();
            }
            if (this.end - range < this.regex.thresholdLength) {
                return this.mismatch();
            }
            schStart = s3;
            if (this.regex.dMax != 0) {
                schStart = this.regex.dMax == Integer.MAX_VALUE ? this.end : ((schStart += this.regex.dMax) > this.end ? this.end : this.enc.leftAdjustCharHead(this.bytes, start2, schStart, this.end));
            }
            if (!this.backwardSearchRange(this.bytes, this.str, this.end, schStart, range, adjrange)) {
                return this.mismatch();
            }
        }
        do {
            if (!this.matchCheck(origStart, s3, prev = this.enc.prevCharHead(this.bytes, this.str, s3, this.end))) continue;
            return this.match(s3);
        } while ((s3 = prev) >= range);
        return this.mismatch();
    }

    private boolean endBuf(int start2, int range, int minSemiEnd, int maxSemiEnd) {
        if (maxSemiEnd - this.str < this.regex.anchorDmin) {
            return true;
        }
        if (range > start2) {
            if (minSemiEnd - start2 > this.regex.anchorDmax) {
                start2 = minSemiEnd - this.regex.anchorDmax;
                start2 = start2 < this.end ? this.enc.rightAdjustCharHead(this.bytes, this.str, start2, this.end) : this.enc.prevCharHead(this.bytes, this.str, this.end, this.end);
            }
            if (maxSemiEnd - (range - 1) < this.regex.anchorDmin) {
                range = maxSemiEnd - this.regex.anchorDmin + 1;
            }
            if (start2 >= range) {
                return true;
            }
        } else {
            if (minSemiEnd - range > this.regex.anchorDmax) {
                range = minSemiEnd - this.regex.anchorDmax;
            }
            if (maxSemiEnd - start2 < this.regex.anchorDmin) {
                start2 = maxSemiEnd - this.regex.anchorDmin;
                start2 = this.enc.leftAdjustCharHead(this.bytes, this.str, start2, this.end);
            }
            if (range > start2) {
                return true;
            }
        }
        return false;
    }

    private int match(int s2) {
        return s2 - this.str;
    }

    private int mismatch() {
        if (this.msaBestLen >= 0) {
            int s2 = this.msaBestS;
            return this.match(s2);
        }
        return -1;
    }
}

