/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Random;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyObject {
    public static Random globalRandom = new Random();
    private static IRubyObject globalSeed;
    private Random random = new Random();
    private IRubyObject seed;
    private static ObjectAllocator RANDOM_ALLOCATOR;

    public static RubyClass createRandomClass(Ruby runtime2) {
        RubyClass randomClass = runtime2.defineClass("Random", runtime2.getObject(), RANDOM_ALLOCATOR);
        runtime2.setRandomClass(randomClass);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        return randomClass;
    }

    private RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        long seedLong = this.random.nextLong();
        this.seed = RubyBignum.newBignum(runtime2, seedLong);
        this.random.setSeed(seedLong);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        long seedLong;
        if (arg2 instanceof RubyFloat) {
            this.seed = RubyBignum.num2fix(((RubyFloat)arg2).truncate());
            seedLong = RubyNumeric.num2long(this.seed);
        } else if (arg2 instanceof RubyBignum) {
            this.seed = arg2;
            seedLong = (long)RubyBignum.big2dbl((RubyBignum)arg2);
        } else {
            this.seed = arg2.convertToInteger();
            seedLong = RubyNumeric.num2long(this.seed);
        }
        this.random.setSeed(seedLong);
        return this;
    }

    @JRubyMethod(name={"seed"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject seed(ThreadContext context) {
        return this.seed;
    }

    @JRubyMethod(name={"rand"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.randCommon(context, context.nil, globalRandom, false);
    }

    @JRubyMethod(name={"rand"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyRandom.randCommon(context, arg0, globalRandom, false);
    }

    @JRubyMethod(name={"rand"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject randObj(ThreadContext context) {
        return RubyRandom.randCommon(context, context.nil, this.random, true);
    }

    @JRubyMethod(name={"rand"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject randObj(ThreadContext context, IRubyObject arg0) {
        return RubyRandom.randCommon(context, arg0, this.random, true);
    }

    private static IRubyObject randCommon(ThreadContext context, IRubyObject arg2, Random random, boolean raiseArgError) {
        Ruby runtime2 = context.getRuntime();
        if (arg2.isNil()) {
            return runtime2.newFloat(random.nextFloat());
        }
        if (arg2 instanceof RubyRange) {
            boolean returnFloat;
            RubyRange range = (RubyRange)arg2;
            IRubyObject first2 = range.first();
            IRubyObject last2 = range.last();
            boolean bl = returnFloat = first2 instanceof RubyFloat || last2 instanceof RubyFloat;
            if (returnFloat) {
                first2 = first2.convertToFloat();
                last2 = last2.convertToFloat();
            }
            if (range.include_p19(context, last2).isTrue() && !returnFloat) {
                last2 = last2.callMethod(context, "+", runtime2.newFixnum(1));
            }
            if (!(first2.respondsTo("-") && first2.respondsTo("+") && last2.respondsTo("-") && last2.respondsTo("+"))) {
                throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
            }
            IRubyObject difference = last2.callMethod(context, "-", first2);
            if (returnFloat) {
                double max2 = RubyNumeric.num2dbl(difference);
                double rand2 = random.nextDouble() * ((RubyFloat)difference).getDoubleValue();
                return RubyFloat.newFloat(runtime2, ((RubyFloat)first2).getDoubleValue() + rand2);
            }
            int max3 = (int)RubyNumeric.num2long(difference);
            int rand3 = random.nextInt(max3);
            return RubyNumeric.num2fix(first2.callMethod(context, "+", runtime2.newFixnum(rand3)));
        }
        if (arg2 instanceof RubyFloat) {
            double max4 = RubyNumeric.num2dbl(arg2);
            if (max4 <= 0.0 && raiseArgError) {
                throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
            }
            return runtime2.newFloat((double)random.nextFloat() * max4);
        }
        int max5 = 0;
        if (arg2 instanceof RubyBignum) {
            max5 = (int)RubyBignum.big2dbl((RubyBignum)arg2);
        } else {
            if (arg2.respondsTo("to_i")) {
                arg2 = arg2.callMethod(context, "to_i");
            }
            max5 = (int)RubyNumeric.num2long(arg2);
        }
        if (max5 <= 0 && raiseArgError) {
            throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
        }
        int rand4 = random.nextInt(max5);
        if (arg2 instanceof RubyBignum) {
            return RubyBignum.newBignum(runtime2, rand4);
        }
        return runtime2.newFixnum(rand4);
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srand(context, recv2, context.getRuntime().getNil());
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.srandCommon(context, recv2, arg2, false);
    }

    public static IRubyObject srandCommon(ThreadContext context, IRubyObject recv2, IRubyObject arg2, boolean acceptZero) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject newSeed2 = arg2;
        IRubyObject previousSeed = globalSeed;
        long seedArg = 0L;
        if (arg2 instanceof RubyBignum) {
            seedArg = ((RubyBignum)arg2).getValue().longValue();
        } else if (!arg2.isNil()) {
            seedArg = RubyNumeric.num2long(arg2);
        }
        if (arg2.isNil() || !acceptZero && seedArg == 0L) {
            newSeed2 = RubyNumeric.int2fix(runtime2, System.currentTimeMillis() ^ (long)recv2.hashCode() ^ runtime2.incrementRandomSeedSequence() ^ (long)runtime2.getRandom().nextInt(Math.max(1, Math.abs((int)runtime2.getRandomSeed()))));
            seedArg = RubyNumeric.fix2long(newSeed2);
        }
        globalSeed = newSeed2;
        globalRandom.setSeed(seedArg);
        return previousSeed;
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        if (!(obj instanceof RubyRandom)) {
            return runtime2.getFalse();
        }
        RubyRandom r2 = (RubyRandom)obj;
        return RuntimeHelpers.invokedynamic(context, this.seed(context), 1, r2.seed(context));
    }

    @JRubyMethod(name={"marshal_dump"}, backtrace=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.getRuntime().newArray((IRubyObject)this, this.seed);
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() > 0) {
            RubyRandom rand2 = (RubyRandom)load2.eltInternal(0);
            this.seed = load2.eltInternal(1);
            this.random.setSeed(this.seed.convertToInteger().getLongValue());
        }
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject bytes(ThreadContext context, IRubyObject arg2) {
        int size2 = RubyNumeric.num2int(arg2);
        byte[] bytes2 = new byte[size2];
        this.random.nextBytes(bytes2);
        return context.getRuntime().newString(new ByteList(bytes2));
    }

    public static double randomReal(ThreadContext context, IRubyObject obj) {
        Random random = null;
        if (obj.equals(context.runtime.getRandomClass())) {
            random = globalRandom;
        }
        if (obj instanceof RubyRandom) {
            random = ((RubyRandom)obj).random;
        }
        if (random != null) {
            return random.nextDouble();
        }
        double d = RubyNumeric.num2dbl(RuntimeHelpers.invoke(context, obj, "rand"));
        if (d < 0.0 || d >= 1.0) {
            throw context.runtime.newRangeError("random number too big: " + d);
        }
        return d;
    }

    @JRubyMethod(name={"new_seed"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        globalRandom = new Random();
        long rand2 = globalRandom.nextLong();
        globalRandom.setSeed(rand2);
        return RubyBignum.newBignum(runtime2, rand2);
    }

    static {
        RANDOM_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyRandom(runtime2, klass);
            }
        };
    }
}

