/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.BindingStorePlacementNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

public class BindingStorePlacementProblem
extends DataFlowProblem {
    public BindingStorePlacementProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    public String getName() {
        return "Binding Stores Placement Analysis";
    }

    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new BindingStorePlacementNode(this, bb);
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public boolean scopeDefinesVariable(Variable v) {
        return this.getCFG().definesLocalVariable(v);
    }

    public boolean scopeUsesVariable(Variable v) {
        return this.getCFG().usesLocalVariable(v);
    }

    public void addStoreAndBindingAllocInstructions() {
        for (FlowGraphNode n : this._fgNodes) {
            BindingStorePlacementNode bspn = (BindingStorePlacementNode)n;
            bspn.addStoreAndBindingAllocInstructions();
        }
    }
}

