/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array
extends Operand {
    public final Operand[] elts;

    public Array() {
        this.elts = new Operand[0];
    }

    public Array(List<Operand> elts) {
        this(elts.toArray(new Operand[elts.size()]));
    }

    public Array(Operand[] elts) {
        this.elts = elts == null ? new Operand[]{} : elts;
    }

    public boolean isBlank() {
        return this.elts.length == 0;
    }

    public String toString() {
        return "Array:" + (this.isBlank() ? "" : Arrays.toString(this.elts));
    }

    @Override
    public boolean isConstant() {
        for (Operand o : this.elts) {
            if (o.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            this.elts[i2] = this.elts[i2].getSimplifiedOperand(valueMap);
        }
        return this;
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        if (!getSubArray) {
            return argIndex < this.elts.length ? this.elts[argIndex] : Nil.NIL;
        }
        if (argIndex < this.elts.length) {
            Operand[] newElts = new Operand[this.elts.length - argIndex];
            System.arraycopy(this.elts, argIndex, newElts, 0, newElts.length);
            return new Array(newElts);
        }
        return new Array();
    }

    @Override
    public IRClass getTargetClass() {
        return IRClass.getCoreClass("Array");
    }

    public Operand toArray() {
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.elts) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.isConstant()) {
            return this;
        }
        Operand[] newElts = new Operand[this.elts.length];
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            newElts[i2] = this.elts[i2].cloneForInlining(ii);
        }
        return new Array(newElts);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        IRubyObject[] elements = new IRubyObject[this.elts.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (IRubyObject)this.elts[i2].retrieve(interp);
        }
        return interp.getRuntime().newArray(elements);
    }
}

