/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.compiler.ir.operands.Variable;
import org.jruby.interpreter.InterpreterContext;

public class LocalVariable
extends Variable {
    public final String name;
    private int location;

    public LocalVariable(String name2, int location) {
        this.name = name2;
        this.location = location;
    }

    public void setLocation(int slot) {
        this.location = slot;
    }

    public int getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isSelf() {
        return this.name.equals("%self");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalVariable)) {
            return false;
        }
        return this.name.equals(((LocalVariable)obj).name);
    }

    public int compareTo(Object arg0) {
        if (!(arg0 instanceof LocalVariable)) {
            return 0;
        }
        return this.name.compareTo(((LocalVariable)arg0).name);
    }

    public Object retrieve(InterpreterContext interp) {
        return interp.getLocalVariable(this.location);
    }

    public Object store(InterpreterContext interp, Object value2) {
        return interp.setLocalVariable(this.location, value2);
    }
}

