/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.URLUtil;

public class JRubyUtilLibrary
implements Library {
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyModule mJRubyUtil = runtime2.getOrCreateModule("JRuby").defineModuleUnder("Util");
        mJRubyUtil.defineAnnotatedMethods(JRubyUtilLibrary.class);
    }

    @JRubyMethod(module=true)
    public static void gc(IRubyObject recv2) {
        System.gc();
    }

    @JRubyMethod(name={"objectspace"}, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyBoolean.newBoolean(runtime2, runtime2.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace="}, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = recv2.getRuntime();
        runtime2.setObjectSpaceEnabled(arg2.isTrue());
        return runtime2.getNil();
    }

    @JRubyMethod(name={"classloader_resources"}, module=true)
    public static IRubyObject getClassLoaderResources(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = recv2.getRuntime();
        String resource2 = arg2.convertToString().toString();
        ArrayList<RubyString> urlStrings = new ArrayList<RubyString>();
        try {
            Enumeration<URL> urls = runtime2.getJRubyClassLoader().getResources(resource2);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String urlString = URLUtil.getPath(url);
                urlStrings.add(runtime2.newString(urlString));
            }
            return RubyArray.newArrayNoCopy(runtime2, urlStrings.toArray(new IRubyObject[urlStrings.size()]));
        }
        catch (IOException ignore) {
            return runtime2.newEmptyArray();
        }
    }
}

