/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.SelectorFactory;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyTCPServer(runtime2, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");

    static void createTCPServer(Ruby runtime2) {
        RubyClass rb_cTCPServer = runtime2.defineClass("TCPServer", runtime2.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime2.getObject().fastSetConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE, backtrace=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port;
        IRubyObject hostname = args2[0];
        IRubyObject iRubyObject = port = args2.length > 1 ? args2[1] : context.getRuntime().getNil();
        if (hostname.isNil() || hostname instanceof RubyString && ((RubyString)hostname).isEmpty()) {
            hostname = context.getRuntime().newString("0.0.0.0");
        } else if (hostname instanceof RubyFixnum) {
            port = hostname;
            hostname = context.getRuntime().newString("0.0.0.0");
        }
        String shost = hostname.convertToString().toString();
        try {
            int portInt;
            InetAddress addr2 = InetAddress.getByName(shost);
            this.ssc = ServerSocketChannel.open();
            if (port instanceof RubyInteger) {
                portInt = RubyNumeric.fix2int(port);
            } else {
                RubyString portString = port.convertToString();
                RubyInteger portInteger = portString.convertToInteger("to_i");
                portInt = RubyNumeric.fix2int(portInteger);
                if (portInt <= 0) {
                    portInt = RubyNumeric.fix2int(RubySocket.getservbyname(context, context.getRuntime().getObject(), new IRubyObject[]{portString}));
                }
            }
            this.socket_address = new InetSocketAddress(addr2, portInt);
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)this.ssc, new ModeFlags(ModeFlags.RDWR)));
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (BindException e) {
            String msg = e.getMessage();
            msg = msg == null ? "bind" : "bind - " + msg;
            if (ADDR_NOT_AVAIL_PATTERN.matcher(msg).find()) {
                throw context.getRuntime().newErrnoEADDRNOTAVAILError(msg);
            }
            throw context.getRuntime().newErrnoEADDRINUSEError(msg);
        }
        catch (SocketException e) {
            String msg = e.getMessage();
            if (msg.indexOf("Permission denied") != -1) {
                throw context.getRuntime().newErrnoEACCESError("bind(2)");
            }
            throw RubyTCPServer.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "initialize: name or service not known");
        }
        catch (IllegalArgumentException iae) {
            throw RubyTCPServer.sockerr(context.getRuntime(), iae.getMessage());
        }
        return this;
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept(ThreadContext context) {
        RubyTCPSocket socket2 = new RubyTCPSocket(context.getRuntime(), context.getRuntime().fastGetClass("TCPSocket"));
        try {
            boolean ready2;
            while (!(ready2 = context.getThread().select(this, 16))) {
                context.pollThreadEvents();
            }
            try {
                SocketChannel connected = this.ssc.accept();
                connected.finishConnect();
                Object object = connected.blockingLock();
                synchronized (object) {
                    connected.configureBlocking(false);
                    connected.configureBlocking(true);
                }
                socket2.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)connected, new ModeFlags(ModeFlags.RDWR)));
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
            return socket2;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(context.getRuntime(), "problem when accepting");
        }
    }

    @Deprecated
    public IRubyObject accept_nonblock() {
        return this.accept_nonblock(this.getRuntime().getCurrentContext());
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context) {
        RubyTCPSocket socket2 = new RubyTCPSocket(context.getRuntime(), context.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            boolean oldBlocking = this.ssc.isBlocking();
            this.ssc.configureBlocking(false);
            selector = SelectorFactory.openWithRetryFrom(this.getRuntime(), SelectorProvider.provider());
            boolean ready2 = context.getThread().select(this, 16, 0L);
            if (!ready2) {
                throw context.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            try {
                socket2.initSocket(context.getRuntime(), new ChannelDescriptor((Channel)this.ssc.accept(), new ModeFlags(ModeFlags.RDWR)));
            }
            catch (InvalidValueException ex) {
                throw context.getRuntime().newErrnoEINVALError();
            }
            RubyTCPSocket rubyTCPSocket = socket2;
            Object var9_10 = null;
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.ssc.configureBlocking(oldBlocking);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
                return rubyTCPSocket;
                catch (IOException e) {
                    throw RubyTCPServer.sockerr(context.getRuntime(), "problem when accepting");
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.ssc.configureBlocking(oldBlocking);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    @Deprecated
    public IRubyObject listen(IRubyObject backlog) {
        return this.listen(this.getRuntime().getCurrentContext(), backlog);
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"peeraddr"}, rest=true)
    public IRubyObject peeraddr(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(ThreadContext context, IRubyObject[] args2) {
        throw context.getRuntime().newNotImplementedError("not supported");
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPServer.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            iRubyObject = block.yield(context, tcpServer);
            Object var7_6 = null;
            tcpServer.callMethod(context, "close");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            tcpServer.callMethod(context, "close");
            throw throwable;
        }
        return iRubyObject;
    }

    public IRubyObject gets(ThreadContext context) {
        throw context.getRuntime().newErrnoENOTCONNError();
    }
}

