/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOChannel;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.InvalidValueException;

public class IOJavaAddons {
    @JRubyMethod
    public static IRubyObject to_inputstream(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        Ruby runtime2 = context.getRuntime();
        try {
            io2.getOpenFile().checkReadable(context.getRuntime());
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getInStream());
    }

    @JRubyMethod
    public static IRubyObject to_outputstream(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        Ruby runtime2 = context.getRuntime();
        try {
            io2.getOpenFile().checkWritable(context.getRuntime());
        }
        catch (IOException ex) {
            throw runtime2.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime2.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getOutStream());
    }

    @JRubyMethod
    public static IRubyObject to_channel(ThreadContext context, IRubyObject self) {
        RubyIO io2 = (RubyIO)self;
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io2.getChannel());
    }

    public static class AnyIO {
        @JRubyMethod(name={"to_inputstream"})
        public static IRubyObject any_to_inputstream(ThreadContext context, IRubyObject self) {
            return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), new IOInputStream(self));
        }

        @JRubyMethod(name={"to_outputstream"})
        public static IRubyObject any_to_outputstream(ThreadContext context, IRubyObject self) {
            return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), new IOOutputStream(self));
        }

        @JRubyMethod(name={"to_channel"})
        public static IRubyObject any_to_channel(ThreadContext context, IRubyObject self) {
            IOChannel channel;
            if (self.respondsTo("read")) {
                channel = self.respondsTo("write") || self.respondsTo("<<") ? new IOChannel.IOReadableWritableByteChannel(self) : new IOChannel.IOReadableByteChannel(self);
            } else if (self.respondsTo("write") || self.respondsTo("<<")) {
                channel = new IOChannel.IOWritableByteChannel(self);
            } else {
                throw context.getRuntime().newTypeError(self.inspect().toString() + " does not respond to any of read, write, or <<");
            }
            return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), channel);
        }
    }
}

