/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import org.jruby.lexer.yacc.ISourcePosition;

public class BacktraceElement {
    public String klass;
    public String method;
    public String filename;
    public int line;

    public BacktraceElement() {
    }

    public BacktraceElement(String klass, String method2, String filename2, int line) {
        this.method = method2;
        this.filename = filename2;
        this.line = line;
        this.klass = klass;
    }

    public String toString() {
        return this.klass + "#" + this.method + " at " + this.filename + ":" + this.line;
    }

    public BacktraceElement clone() {
        return new BacktraceElement(this.klass, this.method, this.filename, this.line);
    }

    public static void update(BacktraceElement backtrace2, String klass, String method2, ISourcePosition position) {
        backtrace2.method = method2;
        backtrace2.filename = position.getFile();
        backtrace2.line = position.getLine();
        backtrace2.klass = klass;
    }

    public static void update(BacktraceElement backtrace2, String klass, String method2, String file2, int line) {
        backtrace2.method = method2;
        backtrace2.filename = file2;
        backtrace2.line = line;
        backtrace2.klass = klass;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename2) {
        this.filename = filename2;
    }

    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method2) {
        this.method = method2;
    }
}

