/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import org.jruby.util.io.SelectorFactory;

public class SelectorPool {
    private final List<Selector> pool = new ArrayList<Selector>();

    public synchronized Selector get() throws IOException {
        return this.retrieveFromPool();
    }

    public synchronized void put(Selector selector) {
        this.returnToPool(selector);
    }

    public synchronized void cleanup() {
        while (!this.pool.isEmpty()) {
            Selector selector = this.pool.remove(this.pool.size() - 1);
            try {
                selector.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Selector retrieveFromPool() throws IOException {
        if (!this.pool.isEmpty()) {
            return this.pool.remove(this.pool.size() - 1);
        }
        return SelectorFactory.openWithRetryFrom(null, SelectorProvider.provider());
    }

    private void returnToPool(Selector selector) {
        this.pool.add(selector);
    }
}

