/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.noise;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import nl.captcha.noise.NoiseProducer;

public class StraightLineNoiseProducer
implements NoiseProducer {
    private final Color _color;
    private final int _thickness;
    private final SecureRandom _gen = new SecureRandom();

    public StraightLineNoiseProducer() {
        this(Color.RED, 4);
    }

    public StraightLineNoiseProducer(Color color, int n) {
        this._color = color;
        this._thickness = n;
    }

    public void makeNoise(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        int n3 = this._gen.nextInt(n) + 1;
        int n4 = this._gen.nextInt(n) + 1;
        this.drawLine(graphics2D, n3, n2, n4);
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        graphics.setColor(this._color);
        int n5 = n2 - n4;
        int n6 = n3 - n;
        double d = Math.sqrt(n5 * n5 + n6 * n6);
        double d2 = (double)this._thickness / (2.0 * d);
        double d3 = -d2 * (double)n6;
        double d4 = d2 * (double)n5;
        double d5 = d4 > 0.0 ? 0.5 : -0.5;
        int n7 = (int)(d3 += d3 > 0.0 ? 0.5 : -0.5);
        int n8 = (int)(d4 += d5);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = n4 + n7;
        nArray2[0] = n + n8;
        nArray[1] = n4 - n7;
        nArray2[1] = n - n8;
        nArray[2] = n2 - n7;
        nArray2[2] = n3 - n8;
        nArray[3] = n2 + n7;
        nArray2[3] = n3 + n8;
        graphics.fillPolygon(nArray, nArray2, 4);
    }
}

