/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.datasetenhancer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.DatasetEnhancer;
import thredds.crawlabledataset.CrawlableDataset;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class RegExpAndDurationTimeCoverageEnhancer
implements DatasetEnhancer {
    private static Logger log = LoggerFactory.getLogger(RegExpAndDurationTimeCoverageEnhancer.class);
    private final String matchPattern;
    private final String substitutionPattern;
    private final String duration;
    private final MatchTarget matchTarget;
    private Pattern pattern;

    public static RegExpAndDurationTimeCoverageEnhancer getInstanceToMatchOnDatasetName(String matchPattern, String substitutionPattern, String duration) {
        return new RegExpAndDurationTimeCoverageEnhancer(matchPattern, substitutionPattern, duration, MatchTarget.DATASET_NAME);
    }

    public static RegExpAndDurationTimeCoverageEnhancer getInstanceToMatchOnDatasetPath(String matchPattern, String substitutionPattern, String duration) {
        return new RegExpAndDurationTimeCoverageEnhancer(matchPattern, substitutionPattern, duration, MatchTarget.DATASET_PATH);
    }

    private RegExpAndDurationTimeCoverageEnhancer(String matchPattern, String substitutionPattern, String duration, MatchTarget matchTarget) {
        if (matchPattern == null) {
            throw new IllegalArgumentException("Null match pattern not allowed.");
        }
        if (substitutionPattern == null) {
            throw new IllegalArgumentException("Null substitution pattern not allowed.");
        }
        if (duration == null) {
            throw new IllegalArgumentException("Null duration not allowed.");
        }
        if (matchTarget == null) {
            throw new IllegalArgumentException("Null match target not allowed.");
        }
        this.matchPattern = matchPattern;
        this.substitutionPattern = substitutionPattern;
        this.duration = duration;
        this.matchTarget = matchTarget;
        try {
            this.pattern = Pattern.compile(matchPattern);
        }
        catch (PatternSyntaxException e) {
            log.error("ctor(): bad match pattern <" + this.matchPattern + ">, failed to compile: " + e.getMessage());
            this.pattern = null;
        }
    }

    public MatchTarget getMatchTarget() {
        return this.matchTarget;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getSubstitutionPattern() {
        return this.substitutionPattern;
    }

    public String getDuration() {
        return this.duration;
    }

    public Object getConfigObject() {
        return null;
    }

    public boolean addMetadata(InvDataset dataset, CrawlableDataset crDataset) {
        String matchTargetString;
        if (this.pattern == null) {
            log.error("addMetadata(): bad match pattern <" + this.matchPattern + ">.");
            return false;
        }
        if (this.matchTarget.equals((Object)MatchTarget.DATASET_NAME)) {
            matchTargetString = crDataset.getName();
        } else if (this.matchTarget.equals((Object)MatchTarget.DATASET_PATH)) {
            matchTargetString = crDataset.getPath();
        } else {
            throw new IllegalStateException("Unknown match target [" + this.matchTarget.toString() + "].");
        }
        Matcher matcher = this.pattern.matcher(matchTargetString);
        if (!matcher.find()) {
            return false;
        }
        StringBuffer startTime = new StringBuffer();
        try {
            matcher.appendReplacement(startTime, this.substitutionPattern);
        }
        catch (IndexOutOfBoundsException e) {
            log.error("addMetadata(): capture group mismatch between match pattern <" + this.matchPattern + "> and substitution pattern <" + this.substitutionPattern + ">: " + e.getMessage());
            return false;
        }
        startTime.delete(0, matcher.start());
        try {
            ((InvDatasetImpl)dataset).setTimeCoverage(new DateRange(new DateType(startTime.toString(), null, null), null, new TimeDuration(this.duration), null));
        }
        catch (Exception e) {
            log.warn("addMetadata(): Start time <" + startTime.toString() + "> or duration <" + this.duration + "> not parsable" + " (crDataset.getName() <" + crDataset.getName() + ">, this.matchPattern() <" + this.matchPattern + ">, this.substitutionPattern() <" + this.substitutionPattern + ">): " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchTarget {
        DATASET_NAME,
        DATASET_PATH;

    }
}

