/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.IncreasableEntry;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;

public class BatchablePipe<K, V> {
    private final Entry<K, V> _headEntry = new Entry(null);
    private final AtomicReference<Entry<K, V>> _lastEntryReference = new AtomicReference<Entry<K, Entry<K, V>>>(this._headEntry);

    public boolean put(IncreasableEntry<K, V> increasableEntry) {
        Entry newEntry = new Entry(increasableEntry);
        while (!this._doIncrease(increasableEntry)) {
            Entry<K, V> lastEntryLink = this._lastEntryReference.get();
            Entry nextEntryLink = (Entry)((Entry)lastEntryLink)._nextEntry.getReference();
            if (nextEntryLink == null) {
                if (!((Entry)lastEntryLink)._nextEntry.compareAndSet(null, newEntry, false, false)) continue;
                this._lastEntryReference.set(newEntry);
                return true;
            }
            this._lastEntryReference.compareAndSet(lastEntryLink, nextEntryLink);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IncreasableEntry<K, V> take() {
        boolean[] marked = new boolean[1];
        block0: while (true) {
            Entry<K, V> predecessorEntry = this._headEntry;
            Entry currentEntry = (Entry)((Entry)predecessorEntry)._nextEntry.getReference();
            while (currentEntry != null) {
                Entry successorEntry = (Entry)currentEntry._nextEntry.get(marked);
                if (marked[0]) {
                    if (!((Entry)predecessorEntry)._nextEntry.compareAndSet(currentEntry, successorEntry, false, false)) continue block0;
                    currentEntry = (Entry)((Entry)predecessorEntry)._nextEntry.getReference();
                    continue;
                }
                if (currentEntry._nextEntry.compareAndSet(successorEntry, successorEntry, false, true)) return currentEntry._increasableEntry;
                continue block0;
            }
            break;
        }
        return null;
    }

    private boolean _doIncrease(IncreasableEntry<K, V> increasableEntry) {
        Entry predecessorEntry;
        boolean[] marked = new boolean[1];
        block0: while (true) {
            predecessorEntry = this._headEntry;
            Entry currentEntry = (Entry)predecessorEntry._nextEntry.getReference();
            while (currentEntry != null) {
                Entry successorEntry = (Entry)currentEntry._nextEntry.get(marked);
                if (marked[0]) {
                    if (!predecessorEntry._nextEntry.compareAndSet(currentEntry, successorEntry, false, false)) continue block0;
                    currentEntry = (Entry)predecessorEntry._nextEntry.getReference();
                    continue;
                }
                if (currentEntry._increasableEntry.getKey().equals(increasableEntry.getKey())) {
                    return currentEntry._increasableEntry.increase(increasableEntry.getValue());
                }
                predecessorEntry = currentEntry;
                currentEntry = successorEntry;
            }
            break;
        }
        this._lastEntryReference.set(predecessorEntry);
        return false;
    }

    private static class Entry<K, V> {
        private IncreasableEntry<K, V> _increasableEntry;
        private AtomicMarkableReference<Entry<K, V>> _nextEntry;

        private Entry(IncreasableEntry<K, V> increasableEntry) {
            this._increasableEntry = increasableEntry;
            this._nextEntry = new AtomicMarkableReference<Object>(null, false);
        }
    }
}

