/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LockRegistry {
    private static Object _dummyValue = new Object();
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ReentrantLock>> _lockGroupMap = new ConcurrentHashMap();
    private static Map<String, Object> _prematureLockReleases = new ConcurrentHashMap<String, Object>();

    public static ReentrantLock allocateLock(String groupName, String key) {
        ReentrantLock oldLock;
        ReentrantLock lock;
        ConcurrentHashMap<String, ReentrantLock> oldLockGroup;
        ConcurrentHashMap<String, ReentrantLock> lockGroup = _lockGroupMap.get(groupName);
        if (lockGroup == null && (oldLockGroup = _lockGroupMap.putIfAbsent(groupName, lockGroup = new ConcurrentHashMap())) != null) {
            lockGroup = oldLockGroup;
        }
        if ((lock = lockGroup.get(key)) == null && (oldLock = lockGroup.putIfAbsent(key, lock = new ReentrantLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public static ReentrantLock finallyFreeLock(String groupName, String key, boolean unlock) {
        if (_prematureLockReleases.containsKey(String.valueOf(groupName) + key)) {
            return LockRegistry.freeLock(groupName, key, unlock);
        }
        return null;
    }

    public static void freeAllLock() {
        LockRegistry.freeAllLock(false);
    }

    public static void freeAllLock(boolean unlock) {
        if (unlock) {
            for (Map map : _lockGroupMap.values()) {
                for (ReentrantLock lock : map.values()) {
                    lock.unlock();
                }
            }
        }
        _lockGroupMap.clear();
        _prematureLockReleases.clear();
    }

    public static Map<String, ReentrantLock> freeLock(String groupName) {
        return LockRegistry.freeLock(groupName, false);
    }

    public static Map<String, ReentrantLock> freeLock(String groupName, boolean unlock) {
        Map lockGroup = _lockGroupMap.remove(groupName);
        if (lockGroup == null) {
            _prematureLockReleases.put(groupName, _dummyValue);
            return null;
        }
        if (unlock) {
            for (ReentrantLock lock : lockGroup.values()) {
                lock.unlock();
            }
            _prematureLockReleases.remove(groupName);
        }
        return lockGroup;
    }

    public static ReentrantLock freeLock(String groupName, String key) {
        return LockRegistry.freeLock(groupName, key, false);
    }

    public static ReentrantLock freeLock(String groupName, String key, boolean unlock) {
        Map lockGroup = _lockGroupMap.get(groupName);
        String prematureLockReleasesKey = String.valueOf(groupName) + key;
        if (lockGroup == null) {
            _prematureLockReleases.put(prematureLockReleasesKey, _dummyValue);
            return null;
        }
        ReentrantLock lock = (ReentrantLock)lockGroup.remove(key);
        if (lock == null) {
            _prematureLockReleases.put(prematureLockReleasesKey, _dummyValue);
            return null;
        }
        if (unlock) {
            lock.unlock();
            _prematureLockReleases.remove(prematureLockReleasesKey);
        }
        return lock;
    }

    public static ReentrantLock getLock(String groupName, String key) {
        ConcurrentHashMap<String, ReentrantLock> lockGroup = _lockGroupMap.get(groupName);
        if (lockGroup == null) {
            return null;
        }
        return lockGroup.get(key);
    }
}

