/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationWrapper;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageRoutingBag;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;

public class IntrabandBridgeDestination
extends DestinationWrapper {
    public IntrabandBridgeDestination(Destination destination) {
        super(destination);
    }

    @Override
    public void send(Message message) {
        if (message.getBoolean("LOCAL_MESSAGE")) {
            this.destination.send(message);
            return;
        }
        message.setDestinationName(this.getName());
        MessageRoutingBag messageRoutingBag = (MessageRoutingBag)message.get("MESSAGE_ROUTING_BAG");
        if (messageRoutingBag == null) {
            messageRoutingBag = new MessageRoutingBag(message, true);
            message.put("MESSAGE_ROUTING_BAG", messageRoutingBag);
        }
        this.sendMessageRoutingBag(messageRoutingBag);
        try {
            Message responseMessage = messageRoutingBag.getMessage();
            responseMessage.copyTo(message);
            messageRoutingBag.setMessage(message);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        Set<MessageListener> messageListeners = this.destination.getMessageListeners();
        for (MessageListener messageListener : messageListeners) {
            try {
                messageListener.receive(message);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void sendMessageRoutingBag(MessageRoutingBag messageRoutingBag) {
        List<SPI> spis;
        if (SPIUtil.isSPI()) {
            SPI spi = SPIUtil.getSPI();
            try {
                String routingId = this.toRoutingId(spi);
                messageRoutingBag.appendRoutingId(routingId);
                if (!messageRoutingBag.isRoutingDowncast()) {
                    RegistrationReference registrationReference = spi.getRegistrationReference();
                    this.sendMessageRoutingBag(registrationReference, messageRoutingBag);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((spis = MPIHelperUtil.getSPIs()).isEmpty() && !SPIUtil.isSPI()) {
            MessageBusUtil.addDestination(this.destination);
        } else {
            messageRoutingBag.setRoutingDowncast(true);
            try {
                for (SPI spi : spis) {
                    String routingId = this.toRoutingId(spi);
                    if (messageRoutingBag.isVisited(routingId)) continue;
                    RegistrationReference registrationReference = spi.getRegistrationReference();
                    this.sendMessageRoutingBag(registrationReference, messageRoutingBag);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void sendMessageRoutingBag(RegistrationReference registrationReference, MessageRoutingBag messageRoutingBag) {
        try {
            Intraband intraband = registrationReference.getIntraband();
            Datagram datagram = intraband.sendSyncDatagram(registrationReference, Datagram.createRequestDatagram(SystemDataType.MESSAGE.getValue(), messageRoutingBag.toByteArray()));
            ByteBuffer byteBuffer = datagram.getDataByteBuffer();
            MessageRoutingBag receivedMessageRoutingBag = MessageRoutingBag.fromByteArray(byteBuffer.array());
            Message receivedMessage = receivedMessageRoutingBag.getMessage();
            Message message = messageRoutingBag.getMessage();
            receivedMessage.copyTo(message);
            message.put("MESSAGE_ROUTING_BAG", messageRoutingBag);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String toRoutingId(SPI spi) throws RemoteException {
        String spiProviderName = spi.getSPIProviderName();
        SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
        String spiId = spiConfiguration.getSPIId();
        return spiProviderName.concat("#").concat(spiId);
    }
}

