/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapUtil {
    private static Log _log = LogFactoryUtil.getLog(MapUtil.class);

    public static <K, V> void copy(Map<K, V> master, Map<? super K, ? super V> copy) {
        copy.clear();
        MapUtil.merge(master, copy);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> inputMap, Map<K, V> outputMap, PredicateFilter<K> keyPredicateFilter) {
        for (Map.Entry<K, V> entry : inputMap.entrySet()) {
            if (!keyPredicateFilter.filter(entry.getKey())) continue;
            outputMap.put(entry.getKey(), entry.getValue());
        }
        return outputMap;
    }

    public static boolean getBoolean(Map<String, ?> map, String key) {
        return MapUtil.getBoolean(map, key, false);
    }

    public static boolean getBoolean(Map<String, ?> map, String key, boolean defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getBoolean(array[0], defaultValue);
        }
        return GetterUtil.getBoolean(String.valueOf(value), defaultValue);
    }

    public static double getDouble(Map<String, ?> map, String key) {
        return MapUtil.getDouble(map, key, 0.0);
    }

    public static double getDouble(Map<String, ?> map, String key, double defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getDouble(array[0], defaultValue);
        }
        return GetterUtil.getDouble(String.valueOf(value), defaultValue);
    }

    public static int getInteger(Map<String, ?> map, String key) {
        return MapUtil.getInteger(map, key, 0);
    }

    public static int getInteger(Map<String, ?> map, String key, int defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getInteger(array[0], defaultValue);
        }
        return GetterUtil.getInteger(String.valueOf(value), defaultValue);
    }

    public static long getLong(Map<Long, Long> map, long key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<Long, Long> map, long key, long defaultValue) {
        Long value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static long getLong(Map<String, ?> map, String key) {
        return MapUtil.getLong(map, key, 0L);
    }

    public static long getLong(Map<String, ?> map, String key, long defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getLong(array[0], defaultValue);
        }
        return GetterUtil.getLong(String.valueOf(value), defaultValue);
    }

    public static short getShort(Map<String, ?> map, String key) {
        return MapUtil.getShort(map, key, (short)0);
    }

    public static short getShort(Map<String, ?> map, String key, short defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getShort(array[0], defaultValue);
        }
        return GetterUtil.getShort(String.valueOf(value), defaultValue);
    }

    public static String getString(Map<String, ?> map, String key) {
        return MapUtil.getString(map, key, "");
    }

    public static String getString(Map<String, ?> map, String key, String defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return GetterUtil.getString((String)value, defaultValue);
        }
        if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                return defaultValue;
            }
            return GetterUtil.getString(array[0], defaultValue);
        }
        return GetterUtil.getString(String.valueOf(value), defaultValue);
    }

    public static <K, V> void merge(Map<K, V> master, Map<? super K, ? super V> copy) {
        copy.putAll(master);
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params) {
        return MapUtil.toLinkedHashMap(params, ":");
    }

    public static <T> LinkedHashMap<String, T> toLinkedHashMap(String[] params, String delimiter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] kvp = StringUtil.split(param, delimiter);
            if (kvp.length == 2) {
                map.put(kvp[0], kvp[1]);
            } else if (kvp.length == 3) {
                String type = kvp[2];
                if (StringUtil.equalsIgnoreCase(type, "boolean") || type.equals(Boolean.class.getName())) {
                    map.put(kvp[0], Boolean.valueOf(kvp[1]));
                } else if (StringUtil.equalsIgnoreCase(type, "double") || type.equals(Double.class.getName())) {
                    map.put(kvp[0], new Double(kvp[1]));
                } else if (StringUtil.equalsIgnoreCase(type, "int") || type.equals(Integer.class.getName())) {
                    map.put(kvp[0], new Integer(kvp[1]));
                } else if (StringUtil.equalsIgnoreCase(type, "long") || type.equals(Long.class.getName())) {
                    map.put(kvp[0], new Long(kvp[1]));
                } else if (StringUtil.equalsIgnoreCase(type, "short") || type.equals(Short.class.getName())) {
                    map.put(kvp[0], new Short(kvp[1]));
                } else if (type.equals(String.class.getName())) {
                    map.put(kvp[0], kvp[1]);
                } else {
                    try {
                        Class<?> clazz = Class.forName(type);
                        Constructor<?> constructor = clazz.getConstructor(String.class);
                        map.put(kvp[0], constructor.newInstance(kvp[1]));
                    }
                    catch (Exception e) {
                        _log.error(e.getMessage(), e);
                    }
                }
            }
            ++n2;
        }
        return map;
    }

    public static String toString(Map<?, ?> map) {
        return MapUtil.toString(map, null, null);
    }

    public static String toString(Map<?, ?> map, String hideIncludesRegex, String hideExcludesRegex) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        StringBundler sb = new StringBundler(map.size() * 4 + 1);
        sb.append("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyString = String.valueOf(key);
            if (hideIncludesRegex != null && !keyString.matches(hideIncludesRegex)) {
                value = "********";
            }
            if (hideExcludesRegex != null && keyString.matches(hideExcludesRegex)) {
                value = "********";
            }
            sb.append(keyString);
            sb.append("=");
            if (value instanceof Map) {
                sb.append(MapUtil.toString((Map)value));
            } else if (value instanceof String[]) {
                String valueString = StringUtil.merge((String[])value, ", ");
                sb.append("[".concat(valueString).concat("]"));
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        sb.setStringAt("}", sb.index() - 1);
        return sb.toString();
    }
}

