/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class LayoutSetStagingHandler
implements InvocationHandler,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetStagingHandler.class);
    private static Set<String> _layoutSetBranchMethodNames = new HashSet<String>();
    private LayoutSet _layoutSet;
    private LayoutSetBranch _layoutSetBranch;

    static {
        _layoutSetBranchMethodNames.add("getColorScheme");
        _layoutSetBranchMethodNames.add("getColorSchemeId");
        _layoutSetBranchMethodNames.add("getCss");
        _layoutSetBranchMethodNames.add("getLayoutSetPrototypeLinkEnabled");
        _layoutSetBranchMethodNames.add("getLayoutSetPrototypeUuid");
        _layoutSetBranchMethodNames.add("getLogo");
        _layoutSetBranchMethodNames.add("getLogoId");
        _layoutSetBranchMethodNames.add("getSettings");
        _layoutSetBranchMethodNames.add("getTheme");
        _layoutSetBranchMethodNames.add("getThemeId");
        _layoutSetBranchMethodNames.add("getWapColorScheme");
        _layoutSetBranchMethodNames.add("getWapColorSchemeId");
        _layoutSetBranchMethodNames.add("getWapTheme");
        _layoutSetBranchMethodNames.add("getWapThemeId");
        _layoutSetBranchMethodNames.add("getSettingsProperties");
        _layoutSetBranchMethodNames.add("getSettings");
        _layoutSetBranchMethodNames.add("getStagingLogoId");
        _layoutSetBranchMethodNames.add("getThemeSetting");
        _layoutSetBranchMethodNames.add("getSettingsProperty");
        _layoutSetBranchMethodNames.add("isLayoutSetPrototypeLinkActive");
        _layoutSetBranchMethodNames.add("isEscapedModel");
        _layoutSetBranchMethodNames.add("isLogo");
        _layoutSetBranchMethodNames.add("setColorSchemeId");
        _layoutSetBranchMethodNames.add("setCss");
        _layoutSetBranchMethodNames.add("setLayoutSetPrototypeLinkEnabled");
        _layoutSetBranchMethodNames.add("setLayoutSetPrototypeUuid");
        _layoutSetBranchMethodNames.add("setEscapedModel");
        _layoutSetBranchMethodNames.add("setLogo");
        _layoutSetBranchMethodNames.add("setLogoId");
        _layoutSetBranchMethodNames.add("setSettings");
        _layoutSetBranchMethodNames.add("setSettingsProperties");
        _layoutSetBranchMethodNames.add("setThemeId");
        _layoutSetBranchMethodNames.add("setWapColorSchemeId");
        _layoutSetBranchMethodNames.add("setWapThemeId");
    }

    public LayoutSetStagingHandler(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
        try {
            this._layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new IllegalStateException(e);
        }
    }

    public LayoutSet getLayoutSet() {
        return this._layoutSet;
    }

    public LayoutSetBranch getLayoutSetBranch() {
        return this._layoutSetBranch;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            if (this._layoutSetBranch == null) {
                return method.invoke((Object)this._layoutSet, arguments);
            }
            String methodName = method.getName();
            if (methodName.equals("toEscapedModel")) {
                if (this._layoutSet.isEscapedModel()) {
                    return this;
                }
                return this._toEscapedModel();
            }
            if (methodName.equals("clone")) {
                return this._clone();
            }
            BaseModel<LayoutSet> bean = this._layoutSet;
            if (_layoutSetBranchMethodNames.contains(methodName)) {
                try {
                    Class<?> layoutSetBranchClass = this._layoutSetBranch.getClass();
                    method = layoutSetBranchClass.getMethod(methodName, ReflectionUtil.getParameterTypes(arguments));
                    bean = this._layoutSetBranch;
                }
                catch (NoSuchMethodException nsme) {
                    _log.error(nsme, nsme);
                }
            }
            return method.invoke((Object)bean, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public void setLayoutSetBranch(LayoutSetBranch layoutSetBranch) {
        this._layoutSetBranch = layoutSetBranch;
    }

    private Object _clone() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class}, new LayoutSetStagingHandler(this._layoutSet));
    }

    private LayoutSetBranch _getLayoutSetBranch(LayoutSet layoutSet) throws PortalException, SystemException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        long layoutSetBranchId = ParamUtil.getLong(serviceContext, "layoutSetBranchId");
        LayoutSetBranch layoutSetBranch = null;
        if (serviceContext.isSignedIn()) {
            layoutSetBranch = LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch(serviceContext.getUserId(), layoutSet.getGroupId(), layoutSet.isPrivateLayout(), layoutSet.getLayoutSetId(), layoutSetBranchId);
        } else if (layoutSetBranchId > 0L) {
            layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch(layoutSetBranchId);
        }
        return layoutSetBranch;
    }

    private Object _toEscapedModel() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class}, new LayoutSetStagingHandler(this._layoutSet.toEscapedModel()));
    }
}

