/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.membershippolicy.UserGroupMembershipPolicy;
import com.liferay.portal.service.persistence.UserGroupActionableDynamicQuery;

public abstract class BaseUserGroupMembershipPolicy
implements UserGroupMembershipPolicy {
    @Override
    public boolean isMembershipAllowed(long userId, long userGroupId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{userGroupId}, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipRequired(long userId, long userGroupId) throws PortalException, SystemException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{userGroupId});
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public void verifyPolicy() throws PortalException, SystemException {
        UserGroupActionableDynamicQuery actionableDynamicQuery = new UserGroupActionableDynamicQuery(){

            @Override
            protected void performAction(Object object) throws PortalException, SystemException {
                UserGroup userGroup = (UserGroup)object;
                BaseUserGroupMembershipPolicy.this.verifyPolicy(userGroup);
            }
        };
        actionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(UserGroup userGroup) throws PortalException, SystemException {
        this.verifyPolicy(userGroup, null, null);
    }
}

