/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final JreCompat instance;
    private static StringManager sm;
    private static final boolean jre8Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public Locale forLanguageTag(String languageTag) {
        String language = null;
        String country = null;
        String variant = null;
        int dash = languageTag.indexOf(45);
        if (dash < 0) {
            language = languageTag;
            country = "";
            variant = "";
        } else {
            language = languageTag.substring(0, dash);
            country = languageTag.substring(dash + 1);
            int vDash = country.indexOf(45);
            if (vDash > 0) {
                String cTemp = country.substring(0, vDash);
                variant = country.substring(vDash + 1);
                country = cTemp;
            } else {
                variant = "";
            }
        }
        if (!(JreCompat.isAlpha(language) && JreCompat.isAlpha(country) && JreCompat.isAlpha(variant))) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    private static final boolean isAlpha(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public void setUseServerCipherSuitesOrder(SSLServerSocket socket, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    static {
        sm = StringManager.getManager((String)JreCompat.class.getPackage().getName());
        if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre8Available = true;
        } else if (Jre7Compat.isSupported()) {
            instance = new Jre7Compat();
            jre8Available = false;
        } else {
            instance = new JreCompat();
            jre8Available = false;
        }
    }
}

