/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.iwork.KeynoteContentHandler;
import org.apache.tika.parser.iwork.NumbersContentHandler;
import org.apache.tika.parser.iwork.PagesContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IWorkPackageParser
extends AbstractParser {
    private static final long serialVersionUID = -2160322853809682372L;
    public static final Set<String> IWORK_CONTENT_ENTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("index.apxl", "index.xml", "presentation.apxl")));
    public static final String IWORK_COMMON_ENTRY = "buildVersionHistory.plist";
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.apple.iwork"), IWORKDocumentType.KEYNOTE.getType(), IWORKDocumentType.NUMBERS.getType(), IWORKDocumentType.PAGES.getType())));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);
        ZipArchiveEntry entry = zip.getNextZipEntry();
        while (entry != null) {
            if (!IWORK_CONTENT_ENTRIES.contains(entry.getName())) {
                entry = zip.getNextZipEntry();
                continue;
            }
            BufferedInputStream entryStream = new BufferedInputStream((InputStream)zip, 4096);
            ((InputStream)entryStream).mark(4096);
            IWORKDocumentType type = IWORKDocumentType.detectType(entryStream);
            ((InputStream)entryStream).reset();
            if (type != null) {
                DefaultHandler contentHandler;
                XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
                switch (type) {
                    case KEYNOTE: {
                        contentHandler = new KeynoteContentHandler(xhtml, metadata);
                        break;
                    }
                    case NUMBERS: {
                        contentHandler = new NumbersContentHandler(xhtml, metadata);
                        break;
                    }
                    case PAGES: {
                        contentHandler = new PagesContentHandler(xhtml, metadata);
                        break;
                    }
                    case ENCRYPTED: {
                        contentHandler = null;
                        break;
                    }
                    default: {
                        throw new TikaException("Unhandled iWorks file " + (Object)((Object)type));
                    }
                }
                metadata.add("Content-Type", type.getType().toString());
                xhtml.startDocument();
                if (contentHandler != null) {
                    context.getSAXParser().parse((InputStream)new CloseShieldInputStream((InputStream)entryStream), (DefaultHandler)new OfflineContentHandler((ContentHandler)contentHandler));
                }
                xhtml.endDocument();
            }
            entry = zip.getNextZipEntry();
        }
        zip.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IWORKDocumentType {
        KEYNOTE("http://developer.apple.com/namespaces/keynote2", "presentation", MediaType.application((String)"vnd.apple.keynote")),
        NUMBERS("http://developer.apple.com/namespaces/ls", "document", MediaType.application((String)"vnd.apple.numbers")),
        PAGES("http://developer.apple.com/namespaces/sl", "document", MediaType.application((String)"vnd.apple.pages")),
        ENCRYPTED(null, null, MediaType.application((String)"x-tika-iworks-protected"));

        private final String namespace;
        private final String part;
        private final MediaType type;

        private IWORKDocumentType(String namespace, String part, MediaType type) {
            this.namespace = namespace;
            this.part = part;
            this.type = type;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPart() {
            return this.part;
        }

        public MediaType getType() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IWORKDocumentType detectType(ZipArchiveEntry entry, ZipFile zip) {
            IWORKDocumentType iWORKDocumentType;
            if (entry == null) {
                return null;
            }
            InputStream stream = zip.getInputStream(entry);
            try {
                iWORKDocumentType = IWORKDocumentType.detectType(stream);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            stream.close();
            return iWORKDocumentType;
        }

        public static IWORKDocumentType detectType(ZipArchiveEntry entry, ZipArchiveInputStream zip) {
            if (entry == null) {
                return null;
            }
            return IWORKDocumentType.detectType((InputStream)zip);
        }

        private static IWORKDocumentType detectType(InputStream stream) {
            QName qname = new XmlRootExtractor().extractRootElement(stream);
            if (qname != null) {
                String uri = qname.getNamespaceURI();
                String local = qname.getLocalPart();
                for (IWORKDocumentType type : IWORKDocumentType.values()) {
                    if (!type.getNamespace().equals(uri) || !type.getPart().equals(local)) continue;
                    return type;
                }
            } else {
                try {
                    stream.read();
                }
                catch (UnsupportedZipFeatureException e) {
                    return ENCRYPTED;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

