/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericMMGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DriverOracleMMGeneric
extends DriverGenericMMGeneric
implements IRDBDriver {
    protected static Properties m_defaultMMSQL = null;

    public DriverOracleMMGeneric() {
        this.DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
        this.LAYOUT_TYPE = "MMGeneric";
        this.DATABASE_TYPE = "Oracle";
        this.SQL_FILE = "etc/oracle_mmgeneric.sql";
        this.MAX_LITERAL = 1000;
        this.ID_SQL_TYPE = "INTEGER";
    }

    public IDBID getLiteralID(Literal literal) throws RDFRDBException {
        try {
            String string;
            String string2 = literal.toString();
            if (string2.length() >= this.MAX_LITERAL) {
                string2 = this.getLiteralIdx(string2);
            }
            boolean bl = (string = literal.getLanguage()) == null || string.equals("");
            String string3 = bl ? "getLiteralIDNoLang" : "getLiteralID";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string3);
            preparedStatement.setString(1, string2);
            if (!bl) {
                preparedStatement.setString(2, string);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            IDBID iDBID = null;
            if (resultSet.next()) {
                iDBID = this.wrapDBID(resultSet.getObject(1));
            }
            resultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string3);
            return iDBID;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", (Exception)sQLException);
        }
    }

    public Object wrapFlag(boolean bl) {
        return bl ? new Integer(1) : new Integer(0);
    }

    public Literal getLiteral(IDBID iDBID) throws RDFException {
        Literal literal = super.getLiteral(iDBID);
        if (literal != null && literal.getLanguage() == null) {
            return new LiteralImpl(literal.getString(), "", literal.getWellFormed());
        }
        return literal;
    }

    public IDBID getResourceID(Resource resource) throws RDFException {
        try {
            Object[] objectArray;
            String string;
            ResourceImplRDB resourceImplRDB = (ResourceImplRDB)resource;
            IDBID iDBID = resourceImplRDB.getRDBId();
            if (iDBID != null) {
                return iDBID;
            }
            String string2 = resource.isAnon() ? "_" : resource.getNameSpace();
            IDBID iDBID2 = this.getNamespaceID(string2);
            if (iDBID2 == null) {
                return null;
            }
            resourceImplRDB.setRDBNSId(iDBID2);
            String string3 = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
            boolean bl = string3 == null || string3.equals("");
            String string4 = string = bl ? "getResourceIDNoName" : "getResourceID";
            if (bl) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = iDBID2.getID();
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = string3;
                objectArray = objectArray3;
                objectArray3[1] = iDBID2.getID();
            }
            Object[] objectArray4 = objectArray;
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery(string, objectArray4);
            if (resultSetIterator.hasNext()) {
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                resourceImplRDB.setRDBId(iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find resource", (Exception)sQLException);
        }
    }
}

