/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.sample;

import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RSS;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class RenderToHTML {
    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(stringArray[1]));
            ModelMem modelMem = new ModelMem();
            modelMem.read(string);
            ResIterator resIterator = modelMem.listSubjectsWithProperty(RDF.type, RSS.channel);
            RenderToHTML.writeHTMLHeader(printWriter);
            while (resIterator.hasNext()) {
                RenderToHTML.renderChannel(resIterator.next(), printWriter);
            }
            RenderToHTML.writeHTMLTrailer(printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected static void writeHTMLHeader(PrintWriter printWriter) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
    }

    protected static void writeHTMLTrailer(PrintWriter printWriter) {
        printWriter.println("</BODY>");
    }

    protected static void renderChannel(Resource resource, PrintWriter printWriter) throws RDFException {
        String string = null;
        printWriter.print("<TABLE>\r\n  <TR>\r\n");
        printWriter.println("    <TD>");
        if (resource.hasProperty(RSS.link)) {
            string = resource.getProperty(RSS.link).getString();
        }
        if (string != null) {
            printWriter.print("<A HREF='" + string + "'>");
        }
        if (resource.hasProperty(RSS.title)) {
            printWriter.print("      <H1>");
            printWriter.print(resource.getProperty(RSS.title).getString());
            printWriter.print("</H1>");
        }
        if (string != null) {
            printWriter.print("</A>");
        }
        printWriter.println("");
        if (resource.hasProperty(RSS.description)) {
            printWriter.print("      <P><H3>");
            printWriter.print(resource.getProperty(RSS.description).getString());
            printWriter.print("</H3></P>\r\n");
        }
        printWriter.print("    </TD><TD>\r\n");
        if (resource.hasProperty(RSS.image)) {
            RenderToHTML.renderImage(resource.getProperty(RSS.image).getResource(), printWriter);
        }
        printWriter.print("    </TD><TD>\r\n");
        if (resource.hasProperty(RSS.textinput)) {
            RenderToHTML.renderTextInput(resource.getProperty(RSS.textinput).getResource(), printWriter);
        }
        printWriter.print("    </TD>\r\n  </TR>\r\n  <TR>\r\n    <TD>\r\n");
        printWriter.print("      <TABLE>\r\n");
        if (resource.hasProperty(RSS.items)) {
            Seq seq = resource.getProperty(RSS.items).getSeq();
            int n = 1;
            while (n <= seq.size()) {
                RenderToHTML.renderItem(seq.getResource(n), printWriter);
                ++n;
            }
        }
        printWriter.print("      </TABLE>\r\n    </TD>\r\n  </TR>\r\n</TABLE>\r\n");
    }

    protected static void renderItem(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource == null) {
            return;
        }
        printWriter.print("      <TR><TD>\r\n");
        printWriter.print("          <B><A HREF=\"" + resource.getProperty(RSS.link).getString() + "\">" + resource.getProperty(RSS.title).getString() + "</A></B>\r\n");
        printWriter.print("        </TD><TD>");
        if (resource.hasProperty(RSS.description)) {
            printWriter.print("          " + resource.getProperty(RSS.description).getString() + "\r\n");
        }
        printWriter.print("        </TD>\r\n      </TR>");
    }

    protected static void renderImage(Resource resource, PrintWriter printWriter) throws RDFException {
        String string = null;
        String string2 = null;
        if (resource.hasProperty(RSS.link)) {
            string = resource.getProperty(RSS.link).getString();
        }
        if (resource.hasProperty(RSS.title)) {
            string2 = resource.getProperty(RSS.title).getString();
        }
        if (string != null) {
            printWriter.print("<A HREF='" + string + "'>");
        }
        printWriter.print("<IMG SRC='" + resource.getURI() + "'");
        if (string2 != null) {
            printWriter.print(" ALT='" + string2 + "'");
        }
        printWriter.print(">");
    }

    protected static void renderTextInput(Resource resource, PrintWriter printWriter) throws RDFException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (!resource.hasProperty(RSS.link)) {
            return;
        }
        string = resource.getProperty(RSS.link).getString();
        if (!resource.hasProperty(RSS.title)) {
            return;
        }
        string2 = resource.getProperty(RSS.title).getString();
        if (!resource.hasProperty(RSS.name)) {
            return;
        }
        string3 = resource.getProperty(RSS.name).getString();
        if (!resource.hasProperty(RSS.description)) {
            return;
        }
        string4 = resource.getProperty(RSS.description).getString();
        printWriter.println("<FORM METHOD='get' ACTION='" + string + "'>");
        printWriter.println("<P>" + string2 + " <INPUT NAME='" + string3 + "' size='20'></p>");
        printWriter.println("<p>" + string4 + "</P>");
        printWriter.println("</FORM>");
    }
}

