/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.kernel.bean.ConstantsBeanFactory;
import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConstantsBeanFactoryImpl
implements ConstantsBeanFactory {
    protected static ConcurrentMap<EqualityWeakReference<Class<?>>, Reference<?>> constantsBeans = new ConcurrentHashMap();
    protected static ReferenceQueue<Class<?>> constantsClassReferenceQueue = new ReferenceQueue();

    public Object getConstantsBean(Class<?> constantsClass) {
        EqualityWeakReference staleConstantsClassReference;
        Reference constantsBeanReference = (Reference)constantsBeans.get(new EqualityWeakReference(constantsClass));
        Object constantsBean = null;
        if (constantsBeanReference != null) {
            constantsBean = constantsBeanReference.get();
        }
        if (constantsBean == null) {
            constantsBean = ConstantsBeanFactoryImpl.createConstantsBean(constantsClass);
            constantsBeans.put(new EqualityWeakReference(constantsClass, constantsClassReferenceQueue), new WeakReference<Object>(constantsBean));
        }
        while ((staleConstantsClassReference = (EqualityWeakReference)constantsClassReferenceQueue.poll()) != null) {
            constantsBeans.remove(staleConstantsClassReference);
        }
        return constantsBean;
    }

    protected static Object createConstantsBean(Class<?> constantsClass) {
        ClassLoader classLoader = constantsClass.getClassLoader();
        String constantsBeanClassName = String.valueOf(constantsClass.getName()) + "Bean";
        Class constantsBeanClass = null;
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            try {
                constantsBeanClass = classLoader.loadClass(constantsBeanClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            try {
                if (constantsBeanClass == null) {
                    Method defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                    byte[] classData = ConstantsBeanFactoryImpl.generateConstantsBeanClassData(constantsClass);
                    constantsBeanClass = (Class)defineClassMethod.invoke((Object)classLoader, constantsBeanClassName, classData, 0, classData.length);
                }
                return constantsBeanClass.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    protected static byte[] generateConstantsBeanClassData(Class<?> constantsClass) {
        Field[] fields;
        String constantsClassBinaryName = ConstantsBeanFactoryImpl.getClassBinaryName(constantsClass);
        String constantsBeanClassBinaryName = String.valueOf(constantsClassBinaryName) + "Bean";
        String objectClassBinaryName = ConstantsBeanFactoryImpl.getClassBinaryName(Object.class);
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(49, 33, constantsBeanClassBinaryName, null, objectClassBinaryName, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, objectClassBinaryName, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        Field[] fieldArray = fields = constantsClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isStatic(field.getModifiers())) {
                Class<?> fieldClass = field.getType();
                Type fieldType = Type.getType(fieldClass);
                methodVisitor = classWriter.visitMethod(1, "get" + field.getName(), "()" + fieldType.getDescriptor(), null, null);
                methodVisitor.visitCode();
                methodVisitor.visitFieldInsn(178, constantsClassBinaryName, field.getName(), fieldType.getDescriptor());
                int returnOpcode = 176;
                if (fieldClass.isPrimitive()) {
                    returnOpcode = fieldClass == Float.TYPE ? 174 : (fieldClass == Double.TYPE ? 175 : (fieldClass == Long.TYPE ? 173 : 172));
                }
                methodVisitor.visitInsn(returnOpcode);
                methodVisitor.visitMaxs(fieldType.getSize(), 1);
                methodVisitor.visitEnd();
            }
            ++n2;
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    protected static String getClassBinaryName(Class<?> clazz) {
        String className = clazz.getName();
        return className.replace('.', '/');
    }
}

