/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class HypersonicDB
extends BaseDB {
    private static final String[] _HYPERSONIC = new String[]{"//", "true", "false", "'1970-01-01 00:00:00'", "now()", " blob", " blob", " bit", " timestamp", " double", " int", " bigint", " longvarchar", " longvarchar", " varchar", "", "commit"};
    private static HypersonicDB _instance = new HypersonicDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    protected HypersonicDB() {
        super("hypersonic");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) {
        return null;
    }

    @Override
    protected String getServerName() {
        return "hypersonic";
    }

    @Override
    protected String[] getTemplate() {
        return _HYPERSONIC;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String[] template;
            if (line.startsWith("alter_column_name ")) {
                template = this.buildColumnNameTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ rename to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_column_type ")) {
                template = this.buildColumnTypeTokens(line);
                line = StringUtil.replace((String)"alter table @table@ alter column @old-column@ @type@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
            } else if (line.startsWith("alter_table_name ")) {
                template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"alter table @old-table@ rename to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

