/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.jpa;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.dao.orm.jpa.ExceptionTranslator;
import com.liferay.portal.dao.orm.jpa.LockModeTranslator;
import com.liferay.portal.dao.orm.jpa.ScrollableResultsImpl;
import com.liferay.portal.dao.orm.jpa.SessionImpl;
import com.liferay.portal.kernel.dao.orm.CacheMode;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;

public class QueryImpl
implements Query {
    protected Class<?> entityClass;
    protected int firstResult = -1;
    protected FlushModeType flushModeType;
    protected LockModeType lockModeType;
    protected int maxResults = -1;
    protected Map<String, Object> namedParameterMap = new HashMap<String, Object>();
    protected Map<Integer, Object> positionalParameterMap = new HashMap<Integer, Object>();
    protected String queryString;
    protected SessionImpl sessionImpl;
    protected boolean sqlQuery;
    protected boolean strictName = true;

    public QueryImpl(SessionImpl sessionImpl, String queryString, boolean strictName) {
        this.sessionImpl = sessionImpl;
        this.queryString = SQLTransformer.transformFromHqlToJpql(queryString);
        this.strictName = strictName;
    }

    public int executeUpdate() throws ORMException {
        try {
            return this.sessionImpl.executeUpdate(this.queryString, this.positionalParameterMap, this.namedParameterMap, this.strictName, this.firstResult, this.maxResults, this.flushModeType, this.lockModeType, this.sqlQuery, this.entityClass);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Iterator<?> iterate() throws ORMException {
        return this.iterate(true);
    }

    public Iterator<?> iterate(boolean unmodifiable) throws ORMException {
        try {
            return this.list(unmodifiable).iterator();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Object iterateNext() throws ORMException {
        Iterator<?> iterator = this.iterate(false);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public List<?> list() throws ORMException {
        return this.list(false, false);
    }

    public List<?> list(boolean unmodifiable) throws ORMException {
        return this.list(true, unmodifiable);
    }

    public List<?> list(boolean copy, boolean unmodifiable) throws ORMException {
        try {
            Object list = this.sessionImpl.list(this.queryString, this.positionalParameterMap, this.namedParameterMap, this.strictName, this.firstResult, this.maxResults, this.flushModeType, this.lockModeType, this.sqlQuery, this.entityClass);
            if (unmodifiable) {
                list = new UnmodifiableList(list);
            } else if (copy) {
                list = ListUtil.copy(list);
            }
            return list;
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public ScrollableResults scroll() throws ORMException {
        try {
            return new ScrollableResultsImpl(this.list());
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Query setBoolean(int pos, boolean value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setBoolean(String name, boolean value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setCacheable(boolean cacheable) {
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        return this;
    }

    public Query setCacheRegion(String cacheRegion) {
        return this;
    }

    public Query setDouble(int pos, double value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setDouble(String name, double value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public Query setFloat(int pos, float value) {
        this.positionalParameterMap.put(pos, Float.valueOf(value));
        return this;
    }

    public Query setFloat(String name, float value) {
        this.namedParameterMap.put(name, Float.valueOf(value));
        return this;
    }

    public Query setFlushMode(FlushModeType flushModeType) {
        this.flushModeType = flushModeType;
        return this;
    }

    public Query setInteger(int pos, int value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setInteger(String name, int value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockModeType = LockModeTranslator.translate(lockMode);
        return this;
    }

    public Query setLong(int pos, long value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setLong(String name, long value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Query setSerializable(int pos, Serializable value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setSerializable(String name, Serializable value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setShort(int pos, short value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setShort(String name, short value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setString(int pos, String value) {
        this.positionalParameterMap.put(pos, value);
        return this;
    }

    public Query setString(String name, String value) {
        this.namedParameterMap.put(name, value);
        return this;
    }

    public Query setTimestamp(int pos, Timestamp value) {
        Date date = null;
        if (value != null) {
            date = new Date(value.getTime());
        }
        this.positionalParameterMap.put(pos, date);
        return this;
    }

    public Query setTimestamp(String name, Timestamp value) {
        Date date = null;
        if (value != null) {
            date = new Date(value.getTime());
        }
        this.namedParameterMap.put(name, date);
        return this;
    }

    public Object uniqueResult() throws ORMException {
        try {
            return this.sessionImpl.uniqueResult(this.queryString, this.positionalParameterMap, this.namedParameterMap, this.strictName, this.firstResult, this.maxResults, this.flushModeType, this.lockModeType, this.sqlQuery, this.entityClass);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }
}

