/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.jpa;

import com.liferay.portal.dao.orm.jpa.ExceptionTranslator;
import com.liferay.portal.dao.orm.jpa.LockModeTranslator;
import com.liferay.portal.dao.orm.jpa.QueryImpl;
import com.liferay.portal.dao.orm.jpa.SQLQueryImpl;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;

public class SessionImpl
implements Session {
    @PersistenceContext
    protected EntityManager entityManager;

    public void clear() throws ORMException {
        try {
            this.entityManager.clear();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Connection close() throws ORMException {
        return null;
    }

    public boolean contains(Object object) throws ORMException {
        try {
            return this.entityManager.contains(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Query createQuery(String queryString) throws ORMException {
        return this.createQuery(queryString, true);
    }

    public Query createQuery(String queryString, boolean strictName) throws ORMException {
        return new QueryImpl(this, queryString, strictName);
    }

    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        return this.createSQLQuery(queryString, true);
    }

    public SQLQuery createSQLQuery(String queryString, boolean strictName) throws ORMException {
        return new SQLQueryImpl(this, queryString, strictName);
    }

    public void delete(Object object) throws ORMException {
        try {
            this.entityManager.remove(this.entityManager.merge(object));
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public void evict(Object object) throws ORMException {
    }

    public void flush() throws ORMException {
        try {
            this.entityManager.flush();
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this.entityManager.find(clazz, (Object)id);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        try {
            Object entity = this.entityManager.find(clazz, (Object)id);
            LockModeType lockModeType = LockModeTranslator.translate(lockMode);
            if (lockModeType != null) {
                this.entityManager.lock(entity, lockModeType);
            }
            return entity;
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Object getWrappedSession() throws ORMException {
        return this.entityManager;
    }

    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        try {
            return this.entityManager.getReference(clazz, (Object)id);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Object merge(Object object) throws ORMException {
        try {
            return this.entityManager.merge(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public Serializable save(Object object) throws ORMException {
        try {
            this.entityManager.persist(object);
            return null;
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    public void saveOrUpdate(Object object) throws ORMException {
        try {
            this.entityManager.merge(object);
        }
        catch (Exception e2) {
            throw ExceptionTranslator.translate(e2);
        }
    }

    protected int executeUpdate(String queryString, Map<Integer, Object> positionalParameterMap, Map<String, Object> namedParameterMap, boolean strictName, int firstResult, int maxResults, FlushModeType flushMode, LockModeType lockModeType, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, positionalParameterMap, namedParameterMap, strictName, firstResult, maxResults, flushMode, lockModeType, sqlQuery, entityClass);
        return query.executeUpdate();
    }

    protected List<?> list(String queryString, Map<Integer, Object> positionalParameterMap, Map<String, Object> namedParameterMap, boolean strictName, int firstResult, int maxResults, FlushModeType flushMode, LockModeType lockModeType, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, positionalParameterMap, namedParameterMap, strictName, firstResult, maxResults, flushMode, lockModeType, sqlQuery, entityClass);
        return query.getResultList();
    }

    protected Object uniqueResult(String queryString, Map<Integer, Object> positionalParameterMap, Map<String, Object> namedParameterMap, boolean strictName, int firstResult, int maxResults, FlushModeType flushMode, LockModeType lockModeType, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = this._getExecutableQuery(queryString, positionalParameterMap, namedParameterMap, strictName, firstResult, maxResults, flushMode, lockModeType, sqlQuery, entityClass);
        return query.getSingleResult();
    }

    private javax.persistence.Query _getExecutableQuery(String queryString, Map<Integer, Object> positionalParameterMap, Map<String, Object> namedParameterMap, boolean strictName, int firstResult, int maxResults, FlushModeType flushMode, LockModeType lockModeType, boolean sqlQuery, Class<?> entityClass) {
        javax.persistence.Query query = null;
        query = sqlQuery ? (entityClass != null ? this.entityManager.createNativeQuery(queryString, entityClass) : this.entityManager.createNativeQuery(queryString)) : this.entityManager.createQuery(queryString);
        this._setParameters(query, positionalParameterMap, namedParameterMap, strictName);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        if (flushMode != null) {
            query.setFlushMode(flushMode);
        }
        if (lockModeType != null) {
            query.setLockMode(lockModeType);
        }
        return query;
    }

    private void _setParameters(javax.persistence.Query query, Map<Integer, Object> positionalParameterMap, Map<String, Object> namedParameterMap, boolean strictName) {
        Object value;
        for (Map.Entry<Integer, Object> entry : positionalParameterMap.entrySet()) {
            int position = entry.getKey() + 1;
            value = entry.getValue();
            if (value instanceof Date) {
                query.setParameter(position, (Date)value, TemporalType.TIMESTAMP);
                continue;
            }
            query.setParameter(position, value);
        }
        if (!strictName) {
            Set set = query.getParameters();
            HashSet<String> parameterNames = new HashSet<String>();
            if (set != null) {
                for (Parameter parameter : set) {
                    String parameterName = parameter.getName();
                    if (parameterName == null) continue;
                    parameterNames.add(parameterName);
                }
            }
            namedParameterMap.keySet().retainAll(parameterNames);
        }
        for (Map.Entry<Object, Object> entry : namedParameterMap.entrySet()) {
            String name = (String)entry.getKey();
            value = entry.getValue();
            if (value instanceof Date) {
                query.setParameter(name, (Date)value, TemporalType.TIMESTAMP);
                continue;
            }
            query.setParameter(name, value);
        }
    }
}

