/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.sandbox;

import com.liferay.portal.deploy.sandbox.SandboxHandler;
import com.liferay.portal.kernel.deploy.Deployer;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import java.io.File;
import java.io.IOException;

public abstract class BaseSandboxHandler
implements SandboxHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseSandboxHandler.class);
    private Deployer _deployer;
    private File _engineHostDir;
    private String _pluginType;

    public BaseSandboxHandler(Deployer deployer) {
        this._deployer = deployer;
        this._engineHostDir = this.getEngineHostDir();
        this._pluginType = this.getPluginType();
    }

    public void createContextXml(File dir) throws IOException {
        String displayName = this.getDisplayName(dir.getName());
        File contextXml = new File(this._engineHostDir, String.valueOf(displayName) + ".xml");
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<Context crossContext=\"true\" docBase=\"");
        sb.append(dir.getAbsolutePath());
        sb.append("\" ");
        sb.append("path=\"");
        sb.append(displayName);
        sb.append("\" />");
        FileUtil.write((File)contextXml, (String)sb.toString());
    }

    public void createPluginPackageProperties(File dir, String pluginName) throws IOException {
        StringBundler sb = new StringBundler(12);
        sb.append("name=");
        sb.append(pluginName);
        sb.append("\n");
        sb.append("module-group-id=liferay\n");
        sb.append("module-incremental-version=1\n");
        sb.append("tags=\n");
        sb.append("short-description=\n");
        sb.append("change-log=\n");
        sb.append("page-url=http://www.liferay.com\n");
        sb.append("author=Liferay, Inc.\n");
        sb.append("licenses=LGPL\n");
        sb.append("speed-filters-enabled=false\n");
        FileUtil.write((String)(dir + "/WEB-INF/liferay-plugin-package.properties"), (String)sb.toString());
    }

    public void deleteContextXml(File dir) {
        String displayName = this.getDisplayName(dir.getName());
        FileUtil.delete((String)(this._engineHostDir + "/" + displayName + ".xml"));
    }

    @Override
    public void deploy(File dir) throws SandboxDeployException {
        try {
            if (!this.isEnabled(dir)) {
                return;
            }
            String dirName = dir.getName();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deploying " + dirName));
            }
            String pluginName = this.getPluginName(dirName);
            this.createPluginPackageProperties(dir, pluginName);
            PluginPackage pluginPackage = this._deployer.readPluginPackage(dir);
            this.clonePlugin(dir, pluginPackage);
            String displayName = this.getDisplayName(dirName);
            this._deployer.processPluginPackageProperties(dir, displayName, pluginPackage);
            this._deployer.copyJars(dir, pluginPackage);
            this._deployer.copyProperties(dir, pluginPackage);
            this._deployer.copyTlds(dir, pluginPackage);
            this._deployer.copyXmls(dir, displayName, pluginPackage);
            this._deployer.updateWebXml(new File(dir, "WEB-INF/web.xml"), dir, displayName, pluginPackage);
            this.createContextXml(dir);
        }
        catch (Exception e2) {
            throw new SandboxDeployException((Throwable)e2);
        }
    }

    @Override
    public String getDisplayName(String dirName) {
        String displayName = dirName.substring(0, dirName.length() - (this._pluginType.length() + 1));
        StringBundler sb = new StringBundler(5);
        sb.append(displayName);
        sb.append("-SANDBOX-");
        sb.append(this._pluginType);
        return sb.toString();
    }

    public String getPluginName(String dirName) {
        String pluginName = dirName.substring(0, dirName.length() - (this._pluginType.length() + 1));
        return TextFormatter.format((String)pluginName, (int)9);
    }

    public boolean isEnabled(File dir) {
        if (this._engineHostDir == null) {
            return false;
        }
        String dirName = dir.getName();
        return dirName.endsWith("-".concat(this._pluginType));
    }

    @Override
    public void undeploy(File dir) throws SandboxDeployException {
        try {
            if (!this.isEnabled(dir)) {
                return;
            }
            String dirName = dir.getName();
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Undeploying " + dirName));
            }
            this.deleteContextXml(dir);
        }
        catch (Exception e2) {
            throw new SandboxDeployException((Throwable)e2);
        }
    }

    protected abstract void clonePlugin(File var1, PluginPackage var2) throws Exception;

    protected File getEngineHostDir() {
        if (!ServerDetector.isTomcat()) {
            return null;
        }
        String dirName = String.valueOf(System.getProperty("catalina.base")) + "/conf";
        String[] fileNames = FileUtil.find((String)dirName, (String)"**/ROOT.xml", null);
        if (fileNames.length == 0) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to locate ROOT.xml under CATALINA_BASE/conf");
            }
            return null;
        }
        File file = new File(fileNames[0]);
        return file.getParentFile();
    }

    protected abstract String getPluginType();
}

