/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.sandbox;

import com.liferay.portal.deploy.sandbox.BaseSandboxHandler;
import com.liferay.portal.kernel.deploy.Deployer;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PortletSandboxHandler
extends BaseSandboxHandler {
    private static final String _PLUGIN_TYPE = "portlet";
    private Deployer _deployer;

    public PortletSandboxHandler(Deployer deployer) {
        super(deployer);
        this._deployer = deployer;
    }

    @Override
    protected void clonePlugin(File dir, PluginPackage pluginPackage) throws Exception {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("portlet_class", "com.liferay.util.bridges.alloy.AlloyPortlet");
        filterMap.put("portlet_name", "1");
        filterMap.put("portlet_title", pluginPackage.getName());
        filterMap.put("restore_current_view", "false");
        filterMap.put("friendly_url_mapper_class", "com.liferay.util.bridges.alloy.AlloyFriendlyURLMapper");
        filterMap.put("friendly_url_mapping", TextFormatter.format((String)pluginPackage.getName(), (int)1));
        filterMap.put("friendly_url_routes", "com/liferay/util/bridges/alloy/alloy-friendly-url-routes.xml");
        filterMap.put("namespace", TextFormatter.format((String)pluginPackage.getName(), (int)3));
        filterMap.put("package_path", "com.liferay." + TextFormatter.format((String)pluginPackage.getName(), (int)1));
        this._deployer.copyDependencyXml("liferay-display.xml", dir + "/WEB-INF", filterMap);
        this.updateLiferayDisplayXML(dir);
        this._deployer.copyDependencyXml("liferay-portlet.xml", dir + "/WEB-INF", filterMap);
        this._deployer.copyDependencyXml("portlet.xml", dir + "/WEB-INF", filterMap);
        this.updatePortletXML(dir);
        this._deployer.copyDependencyXml("service.xml", dir + "/WEB-INF", filterMap);
    }

    @Override
    protected String getPluginType() {
        return _PLUGIN_TYPE;
    }

    protected Namespace getPortletNamespace(Document document) {
        Element rootElement = document.getRootElement();
        QName qName = rootElement.getQName();
        return qName.getNamespace();
    }

    protected void updateLiferayDisplayXML(File dir) throws Exception {
        File file = new File(dir + "/WEB-INF/liferay-display.xml");
        String content = FileUtil.read((File)file);
        Document document = UnsecureSAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        Element categoryElement = rootElement.addElement("category");
        categoryElement.addAttribute("name", "category.sandbox");
        Element portletElement = categoryElement.addElement(_PLUGIN_TYPE);
        portletElement.addAttribute("id", "1");
        FileUtil.write((File)file, (String)document.formattedString());
    }

    protected void updatePortletXML(File dir) throws Exception {
        File file = new File(dir + "/WEB-INF/portlet.xml");
        String content = FileUtil.read((File)file);
        Document document = UnsecureSAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        List portletElements = rootElement.elements(_PLUGIN_TYPE);
        for (Element portletElement : portletElements) {
            ArrayList<Element> elements = new ArrayList<Element>();
            Element resourceBundleElement = SAXReaderUtil.createElement((QName)SAXReaderUtil.createQName((String)"resource-bundle", (Namespace)this.getPortletNamespace(document)));
            resourceBundleElement.setText("content.Language");
            for (Element element : portletElement.elements()) {
                String elementName = element.getName();
                if (!elementName.equals("init-param") && !elementName.equals("portlet-info")) {
                    elements.add(element);
                    if (elementName.equals("supports")) {
                        elements.add(resourceBundleElement);
                    }
                }
                element.detach();
            }
            for (Element element : elements) {
                portletElement.add(element);
            }
        }
        FileUtil.write((File)file, (String)document.formattedString());
    }
}

