/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.cache.ehcache.EhcacheStreamBootstrapCacheLoader;
import com.liferay.portal.events.ShutdownHook;
import com.liferay.portal.jericho.CachedLoggerProvider;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.nio.intraband.DatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.cache.PortalCacheDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.rpc.RPCDatagramReceiveHandler;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.DistributedRegistry;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.MatchType;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.JspFactorySwapper;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageIndexer;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.WebKeys;
import com.liferay.portlet.messageboards.util.MBMessageIndexer;

public class StartupAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(StartupAction.class);

    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(ids);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new ActionException((Throwable)e2);
        }
    }

    protected void doRun(String[] ids) throws Exception {
        MessageBus messageBus;
        block14: {
            System.out.println("Starting " + ReleaseInfo.getReleaseInfo());
            if (_log.isInfoEnabled() && !PatcherUtil.hasInconsistentPatchLevels()) {
                String installedPatches = StringUtil.merge((Object[])PatcherUtil.getInstalledPatches(), (String)", ");
                if (Validator.isNull((String)installedPatches)) {
                    _log.info((Object)"There are no patches installed");
                } else {
                    _log.info((Object)("The following patches are installed: " + installedPatches));
                }
            }
            DistributedRegistry.registerDistributed((String)"org.apache.struts.taglib.tiles.CompContext", (Direction)Direction.DUPLEX, (MatchType)MatchType.POSTFIX);
            DistributedRegistry.registerDistributed((String)"javax.portlet.markup.head.element", (Direction)Direction.DUPLEX, (MatchType)MatchType.EXACT);
            DistributedRegistry.registerDistributed((String)"javax.portlet.lifecycle_phase", (Direction)Direction.DUPLEX, (MatchType)MatchType.EXACT);
            DistributedRegistry.registerDistributed(WebKeys.class);
            Intraband intraband = MPIHelperUtil.getIntraband();
            intraband.registerDatagramReceiveHandler(SystemDataType.MAILBOX.getValue(), (DatagramReceiveHandler)new MailboxDatagramReceiveHandler());
            messageBus = (MessageBus)PortalBeanLocatorUtil.locate((String)MessageBus.class.getName());
            intraband.registerDatagramReceiveHandler(SystemDataType.MESSAGE.getValue(), (DatagramReceiveHandler)new MessageDatagramReceiveHandler(messageBus));
            intraband.registerDatagramReceiveHandler(SystemDataType.PORTAL_CACHE.getValue(), (DatagramReceiveHandler)new PortalCacheDatagramReceiveHandler());
            intraband.registerDatagramReceiveHandler(SystemDataType.RPC.getValue(), (DatagramReceiveHandler)new RPCDatagramReceiveHandler());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Clear locks");
            }
            try {
                LockLocalServiceUtil.clear();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)"Unable to clear locks because Lock table does not exist");
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Add shutdown hook");
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(new ShutdownHook()));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize template manager");
        }
        TemplateManagerUtil.init();
        IndexerRegistryUtil.register((Indexer)new MBMessageIndexer());
        IndexerRegistryUtil.register((Indexer)new PluginPackageIndexer());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Upgrade database");
        }
        DBUpgrader.upgrade();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize message bus");
        }
        MessageSender messageSender = (MessageSender)PortalBeanLocatorUtil.locate((String)MessageSender.class.getName());
        SynchronousMessageSender synchronousMessageSender = (SynchronousMessageSender)PortalBeanLocatorUtil.locate((String)SynchronousMessageSender.class.getName());
        MessageBusUtil.init((MessageBus)DoPrivilegedUtil.wrap(messageBus), (MessageSender)DoPrivilegedUtil.wrap(messageSender), (SynchronousMessageSender)DoPrivilegedUtil.wrap(synchronousMessageSender));
        ClusterLinkUtil.initialize();
        ClusterExecutorUtil.initialize();
        if (!SPIUtil.isSPI()) {
            ClusterMasterExecutorUtil.initialize();
        }
        EhcacheStreamBootstrapCacheLoader.start();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize scheduler engine lifecycle");
        }
        SchedulerEngineHelperUtil.initialize();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verify database");
        }
        DBUpgrader.verify();
        if (!ClusterMasterExecutorUtil.isEnabled()) {
            BackgroundTaskLocalServiceUtil.cleanUpBackgroundTasks();
        }
        JspFactorySwapper.swap();
        CachedLoggerProvider.install();
    }
}

