/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor;

import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandler;
import com.liferay.portal.kernel.executor.PortalExecutorFactory;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.util.ClassLoaderUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class PortalExecutorFactoryImpl
implements PortalExecutorFactory {
    private boolean _allowCoreThreadTimeout;
    private int _corePoolSize;
    private long _keepAliveTime;
    private int _maxPoolSize;
    private int _maxQueueSize;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private ThreadPoolHandler _threadPoolHandler;
    private TimeUnit _timeUnit;

    public void afterPropertiesSet() {
        if (this._corePoolSize < 0) {
            throw new IllegalArgumentException("Core pool size is less than 0");
        }
        if (this._keepAliveTime < 0L) {
            throw new IllegalArgumentException("Keep alive time is less than 0");
        }
        if (this._maxPoolSize <= 0) {
            throw new IllegalArgumentException("Max pool size is less than or equal to 0");
        }
        if (this._maxPoolSize < this._corePoolSize) {
            throw new IllegalArgumentException("Max pool size is less than core pool size");
        }
        if (this._maxQueueSize <= 0) {
            throw new IllegalArgumentException("Max queue size is less than or equal to 0");
        }
        if (this._rejectedExecutionHandler == null) {
            throw new IllegalArgumentException("Rejected execution handler is null");
        }
        if (this._threadPoolHandler == null) {
            throw new IllegalArgumentException("Thread pool handler is null");
        }
        if (this._timeUnit == null) {
            throw new IllegalArgumentException("Time unit is null");
        }
    }

    public ThreadPoolExecutor createPortalExecutor(String executorName) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(executorName, 5, ClassLoaderUtil.getPortalClassLoader());
        return new ThreadPoolExecutor(this._corePoolSize, this._maxPoolSize, this._keepAliveTime, this._timeUnit, this._allowCoreThreadTimeout, this._maxQueueSize, this._rejectedExecutionHandler, (ThreadFactory)threadFactory, this._threadPoolHandler);
    }

    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this._allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    public void setCorePoolSize(int corePoolSize) {
        this._corePoolSize = corePoolSize;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this._keepAliveTime = keepAliveTime;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this._maxPoolSize = maxPoolSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this._maxQueueSize = maxQueueSize;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setThreadPoolHandler(ThreadPoolHandler threadPoolHandler) {
        this._threadPoolHandler = threadPoolHandler;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this._timeUnit = timeUnit;
    }
}

