/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DoPrivileged
public class StagedModelDataHandlerRegistryImpl
implements StagedModelDataHandlerRegistry {
    private static Log _log = LogFactoryUtil.getLog(StagedModelDataHandlerRegistryImpl.class);
    private Map<String, StagedModelDataHandler<?>> _stagedModelDataHandlers = new HashMap();

    public StagedModelDataHandler<?> getStagedModelDataHandler(String className) {
        return this._stagedModelDataHandlers.get(className);
    }

    public List<StagedModelDataHandler<?>> getStagedModelDataHandlers() {
        return ListUtil.fromMapValues(this._stagedModelDataHandlers);
    }

    public void register(StagedModelDataHandler<?> stagedModelDataHandler) {
        String[] stringArray = stagedModelDataHandler.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (this._stagedModelDataHandlers.containsKey(className)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Duplicate class " + className));
                }
            } else {
                this._stagedModelDataHandlers.put(className, stagedModelDataHandler);
            }
            ++n2;
        }
    }

    public void unregister(StagedModelDataHandler<?> stagedModelDataHandler) {
        String[] stringArray = stagedModelDataHandler.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            this._stagedModelDataHandlers.remove(className);
            ++n2;
        }
    }
}

