/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultExportImportBackgroundTaskStatusMessageTranslator
implements BackgroundTaskStatusMessageTranslator {
    public void translate(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String messageType = message.getString("messageType");
        if (messageType.equals("layout")) {
            this.translateLayoutMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("portlet")) {
            this.translatePortletMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("stagedModel")) {
            this.translateStagedModelMessage(backgroundTaskStatus, message);
        }
    }

    protected void clearBackgroundTaskStatus(BackgroundTaskStatus backgroundTaskStatus) {
        backgroundTaskStatus.clearAttributes();
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("allPortletAdditionCounter", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("allPortletModelAdditionCounters", new HashMap());
        backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("currentPortletAdditionCounter", (Serializable)Long.valueOf(0L));
        backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", new HashMap());
    }

    protected long getTotal(Map<String, LongWrapper> modelCounters) {
        if (modelCounters == null) {
            return 0L;
        }
        long total = 0L;
        for (Map.Entry<String, LongWrapper> entry : modelCounters.entrySet()) {
            LongWrapper longWrapper = entry.getValue();
            total += longWrapper.getValue();
        }
        return total;
    }

    protected synchronized void translateLayoutMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        Map modelAdditionCounters = (Map)message.get("modelAdditionCounters");
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelAdditionCounters)));
        long allPortletAdditionCounter = 0L;
        String[] portletIds = (String[])message.get("portletIds");
        if (portletIds != null) {
            allPortletAdditionCounter = portletIds.length;
        }
        backgroundTaskStatus.setAttribute("allPortletAdditionCounter", (Serializable)Long.valueOf(allPortletAdditionCounter));
    }

    protected synchronized void translatePortletMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String portletId = message.getString("portletId");
        HashMap allPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("allPortletModelAdditionCounters");
        long portletModelAdditionCountersTotal = GetterUtil.getLong((Object)message.get("portletModelAdditionCountersTotal"));
        allPortletModelAdditionCounters.put(portletId, portletModelAdditionCountersTotal);
        backgroundTaskStatus.setAttribute("allPortletModelAdditionCounters", (Serializable)allPortletModelAdditionCounters);
        long allPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allPortletAdditionCounter"));
        long currentPortletAdditionCounter = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentPortletAdditionCounter"));
        if (currentPortletAdditionCounter < allPortletAdditionCounter) {
            backgroundTaskStatus.setAttribute("currentPortletAdditionCounter", (Serializable)Long.valueOf(++currentPortletAdditionCounter));
        }
        HashMap currentPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("currentPortletModelAdditionCounters");
        currentPortletModelAdditionCounters.put(portletId, 0L);
        backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", (Serializable)currentPortletModelAdditionCounters);
        backgroundTaskStatus.setAttribute("portletId", (Serializable)((Object)portletId));
        backgroundTaskStatus.setAttribute("stagedModelName", (Serializable)((Object)""));
        backgroundTaskStatus.setAttribute("stagedModelType", (Serializable)((Object)""));
        backgroundTaskStatus.setAttribute("uuid", (Serializable)((Object)""));
    }

    protected synchronized void translateStagedModelMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String portletId = (String)((Object)backgroundTaskStatus.getAttribute("portletId"));
        if (Validator.isNull((String)portletId)) {
            return;
        }
        long allModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("allModelAdditionCountersTotal"));
        long currentModelAdditionCountersTotal = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("currentModelAdditionCountersTotal"));
        HashMap allPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("allPortletModelAdditionCounters");
        long allPortletModelAdditionCounter = MapUtil.getLong((Map)allPortletModelAdditionCounters, (String)portletId);
        HashMap currentPortletModelAdditionCounters = (HashMap)backgroundTaskStatus.getAttribute("currentPortletModelAdditionCounters");
        long currentPortletModelAdditionCounter = MapUtil.getLong((Map)currentPortletModelAdditionCounters, (String)portletId);
        if (allModelAdditionCountersTotal > currentModelAdditionCountersTotal && allPortletModelAdditionCounter > currentPortletModelAdditionCounter) {
            backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(++currentModelAdditionCountersTotal));
            currentPortletModelAdditionCounters.put(portletId, ++currentPortletModelAdditionCounter);
            backgroundTaskStatus.setAttribute("currentPortletModelAdditionCounters", (Serializable)currentPortletModelAdditionCounters);
        }
        backgroundTaskStatus.setAttribute("stagedModelName", (Serializable)((Object)message.getString("stagedModelName")));
        backgroundTaskStatus.setAttribute("stagedModelType", (Serializable)((Object)message.getString("stagedModelType")));
        backgroundTaskStatus.setAttribute("uuid", (Serializable)((Object)message.getString("uuid")));
    }
}

