/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.license.util;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.license.LicenseInfo;
import com.liferay.portal.license.util.LicenseManager;
import com.liferay.portal.license.util.LicenseUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DoPrivileged
public class DefaultLicenseManagerImpl
implements LicenseManager {
    private static Log _log = LogFactoryUtil.getLog(DefaultLicenseManagerImpl.class);

    public void checkLicense(String productId) {
    }

    public List<Map<String, String>> getClusterLicenseProperties(String clusterNodeId) {
        return null;
    }

    public String getHostName() {
        return PortalUtil.getComputerName();
    }

    public Set<String> getIpAddresses() {
        return LicenseUtil.getIpAddresses();
    }

    public LicenseInfo getLicenseInfo(String productId) {
        return null;
    }

    public List<Map<String, String>> getLicenseProperties() {
        return null;
    }

    public Map<String, String> getLicenseProperties(String productId) {
        return null;
    }

    public int getLicenseState(Map<String, String> licenseProperties) {
        String productId = licenseProperties.get("productId");
        if (Validator.isNull((String)productId)) {
            return 0;
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            byte[] serverIdBytes = LicenseUtil.getServerIdBytes();
            jsonObject.put("cmd", "GET_LICENSE_STATE");
            jsonObject.put("hostName", this.getHostName());
            jsonObject.put("ipAddresses", StringUtil.merge(this.getIpAddresses()));
            jsonObject.put("macAddresses", StringUtil.merge(this.getMacAddresses()));
            jsonObject.put("productId", productId);
            String productVersion = licenseProperties.get("productVersion");
            jsonObject.put("productVersion", productVersion);
            String randomUuid = PortalUUIDUtil.generate();
            jsonObject.put("randomUuid", randomUuid);
            jsonObject.put("serverId", Arrays.toString(serverIdBytes));
            String userCount = licenseProperties.get("userCount");
            jsonObject.put("userCount", userCount);
            jsonObject.put("version", 2);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)response);
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                throw new Exception(errorMessage);
            }
            String responseRandomUuid = responseJSONObject.getString("randomUuid");
            if (responseRandomUuid.equals(randomUuid)) {
                int licenseState = responseJSONObject.getInt("licenseState");
                return licenseState;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2.getMessage());
        }
        return 0;
    }

    public int getLicenseState(String productId) {
        HashMap<String, String> licenseProperties = new HashMap<String, String>();
        licenseProperties.put("productId", productId);
        return this.getLicenseState(licenseProperties);
    }

    public Set<String> getMacAddresses() {
        return LicenseUtil.getMacAddresses();
    }

    public void registerLicense(JSONObject jsonObject) throws Exception {
        String serverId = jsonObject.getString("serverId");
        if (serverId.length() <= 2) {
            return;
        }
        serverId = serverId.substring(1, serverId.length() - 1);
        String[] serverIdArray = StringUtil.split((String)serverId);
        byte[] bytes = new byte[serverIdArray.length];
        int i2 = 0;
        while (i2 < bytes.length) {
            bytes[i2] = Byte.valueOf(serverIdArray[i2].trim());
            ++i2;
        }
        LicenseUtil.writeServerProperties(bytes);
    }
}

