/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.rule.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.Dimensions;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SimpleRuleHandler
implements RuleHandler {
    public static final String PROPERTY_OS = "os";
    public static final String PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX = "screen-physical-height-max";
    public static final String PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN = "screen-physical-height-min";
    public static final String PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX = "screen-physical-width-max";
    public static final String PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN = "screen-physical-width-min";
    public static final String PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX = "screen-resolution-height-max";
    public static final String PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN = "screen-resolution-height-min";
    public static final String PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX = "screen-resolution-width-max";
    public static final String PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN = "screen-resolution-width-min";
    public static final String PROPERTY_TABLET = "tablet";
    private static Log _log = LogFactoryUtil.getLog(SimpleRuleHandler.class);
    private Collection<String> _propertyNames = new ArrayList<String>(10);

    public static String getHandlerType() {
        return SimpleRuleHandler.class.getName();
    }

    public SimpleRuleHandler() {
        this._propertyNames.add(PROPERTY_OS);
        this._propertyNames.add(PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX);
        this._propertyNames.add(PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN);
        this._propertyNames.add(PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX);
        this._propertyNames.add(PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN);
        this._propertyNames.add(PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX);
        this._propertyNames.add(PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN);
        this._propertyNames.add(PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX);
        this._propertyNames.add(PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN);
        this._propertyNames.add(PROPERTY_TABLET);
        this._propertyNames = Collections.unmodifiableCollection(this._propertyNames);
    }

    public boolean evaluateRule(MDRRule mdrRule, ThemeDisplay themeDisplay) {
        Device device = themeDisplay.getDevice();
        if (device == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Rule evaluation is not possible because the information about the device is not available");
            }
            return false;
        }
        if (!this.isValidMultiValue(mdrRule, PROPERTY_OS, device.getOS())) {
            return false;
        }
        if (!this.isValidBooleanValue(mdrRule, PROPERTY_TABLET, device.isTablet())) {
            return false;
        }
        Dimensions screenPhysicalSize = device.getScreenPhysicalSize();
        if (!this.isValidRangeValue(mdrRule, PROPERTY_SCREEN_PHYSICAL_HEIGHT_MAX, PROPERTY_SCREEN_PHYSICAL_HEIGHT_MIN, screenPhysicalSize.getHeight())) {
            return false;
        }
        if (!this.isValidRangeValue(mdrRule, PROPERTY_SCREEN_PHYSICAL_WIDTH_MAX, PROPERTY_SCREEN_PHYSICAL_WIDTH_MIN, screenPhysicalSize.getWidth())) {
            return false;
        }
        Dimensions screenResolution = device.getScreenResolution();
        if (!this.isValidRangeValue(mdrRule, PROPERTY_SCREEN_RESOLUTION_HEIGHT_MAX, PROPERTY_SCREEN_RESOLUTION_HEIGHT_MIN, screenResolution.getHeight())) {
            return false;
        }
        return this.isValidRangeValue(mdrRule, PROPERTY_SCREEN_RESOLUTION_WIDTH_MAX, PROPERTY_SCREEN_RESOLUTION_WIDTH_MIN, screenResolution.getWidth());
    }

    public Collection<String> getPropertyNames() {
        return this._propertyNames;
    }

    public String getType() {
        return SimpleRuleHandler.getHandlerType();
    }

    protected StringBundler getLogStringBundler(MDRRule mdrRule, String value, boolean valid) {
        StringBundler sb = new StringBundler();
        sb.append("Rule ");
        sb.append(mdrRule.getNameCurrentValue());
        sb.append(" with the value ");
        sb.append(value);
        sb.append(" is ");
        if (!valid) {
            sb.append("not ");
        }
        return sb;
    }

    protected boolean isValidBooleanValue(MDRRule mdrRule, String property, boolean value) {
        UnicodeProperties typeSettingsProperties = mdrRule.getTypeSettingsProperties();
        String validValueString = (String)typeSettingsProperties.get((Object)property);
        if (Validator.isNull((String)validValueString)) {
            return true;
        }
        boolean ruleValue = GetterUtil.getBoolean((String)validValueString);
        if (ruleValue != value) {
            this.logBooleanValue(mdrRule, property, value, false);
            return false;
        }
        this.logBooleanValue(mdrRule, property, value, true);
        return true;
    }

    protected boolean isValidMultiValue(MDRRule mdrRule, String property, String value) {
        UnicodeProperties typeSettingsProperties = mdrRule.getTypeSettingsProperties();
        String validValueString = (String)typeSettingsProperties.get((Object)property);
        if (Validator.isNull((String)validValueString)) {
            return true;
        }
        Object[] validValues = StringUtil.split((String)validValueString);
        if (!ArrayUtil.contains((Object[])validValues, (Object)value)) {
            this.logMultiValue(mdrRule, property, value, (String[])validValues, false);
            return false;
        }
        this.logMultiValue(mdrRule, property, value, (String[])validValues, true);
        return true;
    }

    protected boolean isValidRangeValue(MDRRule mdrRule, String maxProperty, String minProperty, float value) {
        UnicodeProperties typeSettingsProperties = mdrRule.getTypeSettingsProperties();
        String max = (String)typeSettingsProperties.get((Object)maxProperty);
        String min = (String)typeSettingsProperties.get((Object)minProperty);
        if (Validator.isNull((String)max) && Validator.isNull((String)min)) {
            this.logRangeValue(mdrRule, maxProperty, minProperty, value, max, min, true);
            return true;
        }
        if (Validator.isNotNull((String)max)) {
            float maxFloat = GetterUtil.getFloat((String)max);
            if (value > maxFloat) {
                this.logRangeValue(mdrRule, maxProperty, minProperty, value, max, min, false);
                return false;
            }
            this.logRangeValue(mdrRule, maxProperty, minProperty, value, max, min, true);
        }
        if (Validator.isNotNull((String)min)) {
            float minFloat = GetterUtil.getFloat((String)min);
            if (value < minFloat) {
                this.logRangeValue(mdrRule, maxProperty, minProperty, value, max, min, false);
                return false;
            }
            this.logRangeValue(mdrRule, maxProperty, minProperty, value, max, min, true);
        }
        return true;
    }

    protected void logBooleanValue(MDRRule mdrRule, String property, boolean value, boolean valid) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        StringBundler sb = this.getLogStringBundler(mdrRule, String.valueOf(value), valid);
        sb.append("the value configured for the property ");
        sb.append(property);
        _log.debug((Object)sb.toString());
    }

    protected void logMultiValue(MDRRule mdrRule, String property, String value, String[] validValues, boolean valid) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        StringBundler sb = this.getLogStringBundler(mdrRule, value, valid);
        sb.append("among the allowed values of ");
        sb.append(StringUtil.merge((Object[])validValues));
        sb.append(" for the property \"");
        sb.append(property);
        sb.append("\"");
        _log.debug((Object)sb.toString());
    }

    protected void logRangeValue(MDRRule mdrRule, String maxProperty, String minProperty, float value, String max, String min, boolean valid) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        StringBundler sb = this.getLogStringBundler(mdrRule, String.valueOf(value), valid);
        sb.append("within the allowed range");
        if (Validator.isNotNull((String)max) && Validator.isNotNull((String)min)) {
            sb.append(" of ");
            sb.append(min);
            sb.append(" and ");
            sb.append(max);
            sb.append(" for the minimum property \"");
            sb.append(minProperty);
            sb.append("\" and the maximum property \"");
            sb.append(maxProperty);
            sb.append("\"");
        }
        _log.debug((Object)sb.toString());
    }
}

