/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.portlet;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.statistics.RequestStatistics;
import com.liferay.portal.monitoring.statistics.portlet.CompanyStatistics;
import com.liferay.portal.monitoring.statistics.portlet.PortletSummaryStatistics;
import com.liferay.portal.monitoring.statistics.portlet.ServerStatistics;
import java.util.Set;

public class RenderRequestSummaryStatistics
implements PortletSummaryStatistics {
    private ServerStatistics _serverStatistics;

    public long getAverageTime() {
        long averageTime = 0L;
        long count = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
                averageTime += requestStatistics.getAverageTime();
                ++count;
            }
        }
        return averageTime / count;
    }

    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getAverageTimeByCompany(companyStatistics);
    }

    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getAverageTimeByCompany(companyStatistics);
    }

    @Override
    public long getAverageTimeByPortlet(String portletId) throws MonitoringException {
        long averageTime = 0L;
        Set<CompanyStatistics> companyStatisticsSet = this._serverStatistics.getCompanyStatisticsSet();
        for (CompanyStatistics companyStatistics : companyStatisticsSet) {
            RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
            averageTime += requestStatistics.getAverageTime();
        }
        return averageTime / (long)companyStatisticsSet.size();
    }

    @Override
    public long getAverageTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getAverageTime();
    }

    @Override
    public long getAverageTimeByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getAverageTime();
    }

    public long getErrorCount() {
        long errorCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            errorCount += this.getErrorCountByCompany(companyStatistics);
        }
        return errorCount;
    }

    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getErrorCountByCompany(companyStatistics);
    }

    public long getErrorCountByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getErrorCountByCompany(companyStatistics);
    }

    @Override
    public long getErrorCountByPortlet(String portletId) throws MonitoringException {
        long errorCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            errorCount += this.getErrorCountByPortlet(portletId, companyStatistics);
        }
        return errorCount;
    }

    @Override
    public long getErrorCountByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getErrorCountByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getErrorCountByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getErrorCountByPortlet(portletId, companyStatistics);
    }

    public long getMaxTime() {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
                if (requestStatistics.getMaxTime() <= maxTime) continue;
                maxTime = requestStatistics.getMaxTime();
            }
        }
        return maxTime;
    }

    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return companyStatistics.getMaxTime();
    }

    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return companyStatistics.getMaxTime();
    }

    @Override
    public long getMaxTimeByPortlet(String portletId) throws MonitoringException {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            long curMaxTime = this.getMaxTimeByPortlet(portletId, companyStatistics);
            if (curMaxTime <= maxTime) continue;
            maxTime = curMaxTime;
        }
        return maxTime;
    }

    @Override
    public long getMaxTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getMaxTimeByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getMaxTimeByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getMaxTimeByPortlet(portletId, companyStatistics);
    }

    public long getMinTime() {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
                if (requestStatistics.getMinTime() >= minTime) continue;
                minTime = requestStatistics.getMinTime();
            }
        }
        return minTime;
    }

    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return companyStatistics.getMinTime();
    }

    public long getMinTimeByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return companyStatistics.getMinTime();
    }

    @Override
    public long getMinTimeByPortlet(String portletId) throws MonitoringException {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            long curMinTime = this.getMinTimeByPortlet(portletId, companyStatistics);
            if (curMinTime >= minTime) continue;
            minTime = curMinTime;
        }
        return minTime;
    }

    @Override
    public long getMinTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getMinTimeByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getMinTimeByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getMinTimeByPortlet(portletId, companyStatistics);
    }

    public long getRequestCount() {
        long requestCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            requestCount += this.getRequestCountByCompany(companyStatistics);
        }
        return requestCount;
    }

    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getRequestCountByCompany(companyStatistics);
    }

    public long getRequestCountByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getRequestCountByCompany(companyStatistics);
    }

    @Override
    public long getRequestCountByPortlet(String portletId) throws MonitoringException {
        long requestCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            requestCount += this.getRequestCountByPortlet(portletId, companyStatistics);
        }
        return requestCount;
    }

    @Override
    public long getRequestCountByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getRequestCountByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getRequestCountByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getRequestCountByPortlet(portletId, companyStatistics);
    }

    public long getSuccessCount() {
        long successCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            successCount += this.getSuccessCountByCompany(companyStatistics);
        }
        return successCount;
    }

    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getSuccessCountByCompany(companyStatistics);
    }

    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getSuccessCountByCompany(companyStatistics);
    }

    @Override
    public long getSuccessCountByPortlet(String portletId) throws MonitoringException {
        long successCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            successCount += this.getSuccessCountByPortlet(portletId, companyStatistics);
        }
        return successCount;
    }

    @Override
    public long getSuccessCountByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getSuccessCountByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getSuccessCountByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getSuccessCountByPortlet(portletId, companyStatistics);
    }

    public long getTimeoutCount() {
        long timeoutCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            timeoutCount += this.getTimeoutCountByCompany(companyStatistics);
        }
        return timeoutCount;
    }

    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getTimeoutCountByCompany(companyStatistics);
    }

    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getTimeoutCountByCompany(companyStatistics);
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId) throws MonitoringException {
        long timeoutCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            timeoutCount += this.getTimeoutCountByPortlet(portletId, companyStatistics);
        }
        return timeoutCount;
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
        return this.getTimeoutCountByPortlet(portletId, companyStatistics);
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
        return this.getTimeoutCountByPortlet(portletId, companyStatistics);
    }

    public void setServerStatistics(ServerStatistics serverStatistics) {
        this._serverStatistics = serverStatistics;
    }

    protected long getAverageTimeByCompany(CompanyStatistics companyStatistics) {
        long averageTime = 0L;
        Set<RequestStatistics> requestStatisticsSet = companyStatistics.getRenderRequestStatisticsSet();
        for (RequestStatistics requestStatistics : requestStatisticsSet) {
            averageTime += requestStatistics.getAverageTime();
        }
        return averageTime / (long)requestStatisticsSet.size();
    }

    protected long getErrorCountByCompany(CompanyStatistics companyStatistics) {
        long errorCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
            errorCount += requestStatistics.getErrorCount();
        }
        return errorCount;
    }

    protected long getErrorCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getErrorCount();
    }

    protected long getMaxTimeByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        long maxTime = 0L;
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        if (requestStatistics.getMaxTime() > maxTime) {
            maxTime = requestStatistics.getMaxTime();
        }
        return maxTime;
    }

    protected long getMinTimeByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        long minTime = 0L;
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        if (requestStatistics.getMinTime() < minTime) {
            minTime = requestStatistics.getMinTime();
        }
        return minTime;
    }

    protected long getRequestCountByCompany(CompanyStatistics companyStatistics) {
        long requestCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
            requestCount += requestStatistics.getRequestCount();
        }
        return requestCount;
    }

    protected long getRequestCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getRequestCount();
    }

    protected long getSuccessCountByCompany(CompanyStatistics companyStatistics) {
        long successCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
            successCount += requestStatistics.getSuccessCount();
        }
        return successCount;
    }

    protected long getSuccessCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getSuccessCount();
    }

    protected long getTimeoutCountByCompany(CompanyStatistics companyStatistics) {
        long timeoutCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getRenderRequestStatisticsSet()) {
            timeoutCount += requestStatistics.getTimeoutCount();
        }
        return timeoutCount;
    }

    protected long getTimeoutCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getRenderRequestStatistics(portletId);
        return requestStatistics.getTimeoutCount();
    }
}

