/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.Action;

public abstract class CMISModel {
    private static Map<String, Action> _mappedActionKeys = new HashMap<String, Action>();
    private static Set<String> _unsupportedActionKeys = new HashSet<String>();
    private Folder _parentFolder;

    static {
        _mappedActionKeys.put("ACCESS", Action.CAN_GET_FOLDER_TREE);
        _mappedActionKeys.put("ADD_DOCUMENT", Action.CAN_CREATE_DOCUMENT);
        _mappedActionKeys.put("ADD_FOLDER", Action.CAN_CREATE_FOLDER);
        _mappedActionKeys.put("ADD_SUBFOLDER", Action.CAN_CREATE_FOLDER);
        _mappedActionKeys.put("DELETE", Action.CAN_DELETE_OBJECT);
        _mappedActionKeys.put("UPDATE", Action.CAN_UPDATE_PROPERTIES);
        _mappedActionKeys.put("VIEW", Action.CAN_GET_PROPERTIES);
        _unsupportedActionKeys.add("ADD_DISCUSSION");
        _unsupportedActionKeys.add("ADD_SHORTCUT");
        _unsupportedActionKeys.add("DELETE_DISCUSSION");
        _unsupportedActionKeys.add("PERMISSIONS");
        _unsupportedActionKeys.add("UPDATE_DISCUSSION");
    }

    public abstract long getCompanyId();

    public String getDescription() {
        return "";
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)this.getModelClassName(), (long)this.getPrimaryKey());
    }

    public abstract String getModelClassName();

    public abstract long getPrimaryKey();

    public void setParentFolder(Folder parentFolder) {
        this._parentFolder = parentFolder;
    }

    protected boolean containsPermission(CmisObject cmisObject, String actionId) throws RepositoryException {
        CMISRepository cmisRepository = this.getCmisRepository();
        if (cmisRepository.isRefreshBeforePermissionCheck()) {
            cmisObject.refresh();
        }
        if (_unsupportedActionKeys.contains(actionId)) {
            return false;
        }
        Action action = _mappedActionKeys.get(actionId);
        if (action == null) {
            throw new RepositoryException("Unexpected permission action " + actionId);
        }
        AllowableActions allowableActions = cmisObject.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        return allowableActionsSet.contains(action);
    }

    protected abstract CMISRepository getCmisRepository();

    protected Folder getParentFolder() throws PortalException, SystemException {
        return this._parentFolder;
    }

    protected User getUser(String createdBy) {
        User user = null;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            String authType = company.getAuthType();
            if (authType.equals("userId")) {
                user = UserLocalServiceUtil.getUser((long)GetterUtil.getLong((String)createdBy));
            } else if (authType.equals("emailAddress")) {
                user = UserLocalServiceUtil.getUserByEmailAddress((long)this.getCompanyId(), (String)createdBy);
            } else if (authType.equals("screenName")) {
                user = UserLocalServiceUtil.getUserByScreenName((long)this.getCompanyId(), (String)createdBy);
            }
        }
        catch (Exception exception) {}
        if (user == null) {
            try {
                user = UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
            }
            catch (Exception exception) {}
        }
        return user;
    }
}

