/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexWriter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneFields;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;

public class LuceneIndexWriter
extends BaseIndexWriter {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexWriter.class);

    public void addDocument(SearchContext searchContext, Document document) throws SearchException {
        try {
            LuceneHelperUtil.addDocument(searchContext.getCompanyId(), this._getLuceneDocument(document));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added document " + document.get("uid")));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void addDocuments(SearchContext searchContext, Collection<Document> documents) throws SearchException {
        for (Document document : documents) {
            this.addDocument(searchContext, document);
        }
    }

    public void deleteDocument(SearchContext searchContext, String uid) throws SearchException {
        try {
            LuceneHelperUtil.deleteDocuments(searchContext.getCompanyId(), new Term("uid", uid));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deleted document " + uid));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void deleteDocuments(SearchContext searchContext, Collection<String> uids) throws SearchException {
        for (String uid : uids) {
            this.deleteDocument(searchContext, uid);
        }
    }

    public void deletePortletDocuments(SearchContext searchContext, String portletId) throws SearchException {
        try {
            LuceneHelperUtil.deleteDocuments(searchContext.getCompanyId(), new Term("portletId", portletId));
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void updateDocument(SearchContext searchContext, Document document) throws SearchException {
        try {
            LuceneHelperUtil.updateDocument(searchContext.getCompanyId(), new Term("uid", document.getUID()), this._getLuceneDocument(document));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Updated document " + document.get("uid")));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void updateDocuments(SearchContext searchContext, Collection<Document> documents) throws SearchException {
        for (Document document : documents) {
            this.updateDocument(searchContext, document);
        }
    }

    private void _addLuceneFieldable(org.apache.lucene.document.Document luceneDocument, String name, boolean numeric, Class<? extends Number> numericClass, boolean tokenized, boolean sortable, float boost, String value) {
        Object luceneFieldable = null;
        luceneFieldable = numeric ? LuceneFields.getNumber(name, value, numericClass) : (tokenized ? LuceneFields.getText(name, value) : LuceneFields.getKeyword(name, value));
        if (sortable) {
            String sortableFieldName = DocumentImpl.getSortableFieldName((String)name);
            luceneFieldable = LuceneFields.getKeyword(sortableFieldName, value);
        }
        luceneFieldable.setBoost(boost);
        luceneDocument.add((Fieldable)luceneFieldable);
    }

    private org.apache.lucene.document.Document _getLuceneDocument(Document document) {
        org.apache.lucene.document.Document luceneDocument = new org.apache.lucene.document.Document();
        Collection fields = document.getFields().values();
        for (Field field : fields) {
            String name = field.getName();
            boolean numeric = field.isNumeric();
            Class numericClass = field.getNumericClass();
            boolean tokenized = field.isTokenized();
            float boost = field.getBoost();
            if (!field.isLocalized()) {
                String[] stringArray = field.getValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (!Validator.isNull((String)value)) {
                        this._addLuceneFieldable(luceneDocument, name, numeric, numericClass, tokenized, field.isSortable(), boost, value);
                    }
                    ++n2;
                }
                continue;
            }
            Map localizedValues = field.getLocalizedValues();
            for (Map.Entry entry : localizedValues.entrySet()) {
                String defaultLanguageId;
                String value = (String)entry.getValue();
                if (Validator.isNull((String)value)) continue;
                Locale locale = (Locale)entry.getKey();
                String languageId = LocaleUtil.toLanguageId((Locale)locale);
                if (languageId.equals(defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()))) {
                    this._addLuceneFieldable(luceneDocument, name, numeric, numericClass, tokenized, field.isSortable(), boost, value);
                }
                String localizedName = DocumentImpl.getLocalizedName((Locale)locale, (String)name);
                this._addLuceneFieldable(luceneDocument, localizedName, numeric, numericClass, tokenized, field.isSortable(), boost, value);
            }
        }
        return luceneDocument;
    }
}

