/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseQuerySuggester;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TokenizerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.lucene.DefaultRelevancyChecker;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.RelevancyChecker;
import com.liferay.portal.search.lucene.SpellCheckerUtil;
import com.liferay.portal.search.lucene.StringDistanceRelevancyChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.util.ReaderUtil;

public class LuceneQuerySuggester
extends BaseQuerySuggester {
    private static final float _SCORES_THRESHOLD_DEFAULT = 0.5f;
    private static Log _log = LogFactoryUtil.getLog(LuceneQuerySuggester.class);
    private float _boostEnd = 1.0f;
    private float _boostStart = 2.0f;
    private int _querySuggestionMaxNGramLength = 50;
    private RelevancyChecker _relevancyChecker = new DefaultRelevancyChecker();
    private StringDistance _stringDistance;
    private Comparator<SuggestWord> _suggestWordComparator = SuggestWordQueue.DEFAULT_COMPARATOR;

    public void setBoostEnd(float boostEnd) {
        this._boostEnd = boostEnd;
    }

    public void setBoostStart(float boostStart) {
        this._boostStart = boostStart;
    }

    public void setQuerySuggestionMaxNGramLength(int querySuggestionMaxNGramLength) {
        this._querySuggestionMaxNGramLength = querySuggestionMaxNGramLength;
    }

    public void setStringDistance(StringDistance stringDistance) {
        this._stringDistance = stringDistance;
    }

    public void setSuggestWordComparator(Comparator<SuggestWord> suggestWordComparator) {
        this._suggestWordComparator = suggestWordComparator;
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws SearchException {
        String languageId = searchContext.getLanguageId();
        String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)"spellCheckWord");
        List keywords = TokenizerUtil.tokenize((String)localizedFieldName, (String)searchContext.getKeywords(), (String)languageId);
        return this.spellCheckKeywords(keywords, localizedFieldName, searchContext, languageId, max);
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) throws SearchException {
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = LuceneHelperUtil.getIndexSearcher(searchContext.getCompanyId());
            String localizedKeywordFieldName = DocumentImpl.getLocalizedName((String)searchContext.getLanguageId(), (String)"keywordSearch");
            BooleanQuery suggestKeywordQuery = this.buildSpellCheckQuery(searchContext.getGroupIds(), searchContext.getKeywords(), searchContext.getLanguageId(), "querySuggestion", this._querySuggestionMaxNGramLength);
            String[] stringArray = this.search(indexSearcher, (Query)suggestKeywordQuery, localizedKeywordFieldName, this._relevancyChecker, max);
            return stringArray;
        }
        catch (Exception e2) {
            throw new SearchException("Unable to suggest query", (Throwable)e2);
        }
        finally {
            try {
                LuceneHelperUtil.releaseIndexSearcher(searchContext.getCompanyId(), indexSearcher);
            }
            catch (IOException ioe) {
                _log.error((Object)"Unable to release searcher", (Throwable)ioe);
            }
        }
    }

    protected void addNGramTermQuery(BooleanQuery booleanQuery, Map<String, String> nGrams, Float boost, BooleanClause.Occur occur) {
        for (Map.Entry<String, String> nGramEntry : nGrams.entrySet()) {
            String name = nGramEntry.getKey();
            String value = nGramEntry.getValue();
            this.addTermQuery(booleanQuery, name, value, boost, occur);
        }
    }

    protected void addTermQuery(BooleanQuery booleanQuery, String termName, String termValue, Float boost, BooleanClause.Occur occur) {
        TermQuery query = new TermQuery(new Term(termName, termValue));
        if (boost != null) {
            query.setBoost(boost.floatValue());
        }
        BooleanClause booleanClause = new BooleanClause((Query)query, occur);
        booleanQuery.add(booleanClause);
    }

    protected BooleanQuery buildGroupIdQuery(long[] groupIds) {
        BooleanQuery booleanQuery = new BooleanQuery();
        this.addTermQuery(booleanQuery, "groupId", String.valueOf(0), null, BooleanClause.Occur.SHOULD);
        if (ArrayUtil.isNotEmpty((long[])groupIds)) {
            long[] lArray = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long groupId = lArray[n2];
                this.addTermQuery(booleanQuery, "groupId", String.valueOf(groupId), null, BooleanClause.Occur.SHOULD);
                ++n2;
            }
        }
        return booleanQuery;
    }

    protected BooleanQuery buildNGramQuery(String word, int maxNGramLength) throws SearchException {
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder((String)word, (int)maxNGramLength);
        BooleanQuery booleanQuery = new BooleanQuery();
        if (this._boostEnd > 0.0f) {
            Map nGramEnds = nGramHolder.getNGramEnds();
            this.addNGramTermQuery(booleanQuery, nGramEnds, Float.valueOf(this._boostEnd), BooleanClause.Occur.SHOULD);
        }
        Map nGrams = nGramHolder.getNGrams();
        for (Map.Entry entry : nGrams.entrySet()) {
            String fieldName = (String)entry.getKey();
            for (String nGram : (List)entry.getValue()) {
                this.addTermQuery(booleanQuery, fieldName, nGram, null, BooleanClause.Occur.SHOULD);
            }
        }
        if (this._boostStart > 0.0f) {
            Map nGramStarts = nGramHolder.getNGramStarts();
            this.addNGramTermQuery(booleanQuery, nGramStarts, Float.valueOf(this._boostStart), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected BooleanQuery buildSpellCheckQuery(long[] groupIds, String word, String languageId, String typeFieldValue, int maxNGramLength) throws SearchException {
        BooleanQuery suggestWordQuery = new BooleanQuery();
        BooleanQuery nGramQuery = this.buildNGramQuery(word, maxNGramLength);
        BooleanClause booleanNGramQueryClause = new BooleanClause((Query)nGramQuery, BooleanClause.Occur.MUST);
        suggestWordQuery.add(booleanNGramQueryClause);
        BooleanQuery groupIdQuery = this.buildGroupIdQuery(groupIds);
        BooleanClause groupIdQueryClause = new BooleanClause((Query)groupIdQuery, BooleanClause.Occur.MUST);
        suggestWordQuery.add(groupIdQueryClause);
        this.addTermQuery(suggestWordQuery, "languageId", languageId, null, BooleanClause.Occur.MUST);
        this.addTermQuery(suggestWordQuery, "portletId", "3", null, BooleanClause.Occur.MUST);
        this.addTermQuery(suggestWordQuery, "type", typeFieldValue, null, BooleanClause.Occur.MUST);
        return suggestWordQuery;
    }

    protected String[] search(IndexSearcher indexSearcher, Query query, String fieldName, RelevancyChecker relevancyChecker, int max) throws IOException {
        int maxScoreDocs = max * 10;
        TopDocs topDocs = indexSearcher.search(query, null, maxScoreDocs);
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        SuggestWordQueue suggestWordQueue = new SuggestWordQueue(max, this._suggestWordComparator);
        int stop = Math.min(scoreDocs.length, maxScoreDocs);
        int i2 = 0;
        while (i2 < stop) {
            SuggestWord suggestWord = new SuggestWord();
            Document document = indexSearcher.doc(scoreDocs[i2].doc);
            Fieldable fieldable = document.getFieldable(fieldName);
            suggestWord.string = fieldable.stringValue();
            boolean relevant = relevancyChecker.isRelevant(suggestWord);
            if (relevant) {
                suggestWordQueue.insertWithOverflow((Object)suggestWord);
            }
            ++i2;
        }
        String[] words = new String[suggestWordQueue.size()];
        int i3 = suggestWordQueue.size() - 1;
        while (i3 >= 0) {
            SuggestWord suggestWord = (SuggestWord)suggestWordQueue.pop();
            words[i3] = suggestWord.string;
            --i3;
        }
        return words;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, List<String>> spellCheckKeywords(List<String> keywords, String localizedFieldName, SearchContext searchContext, String languageId, int max) throws SearchException {
        LinkedHashMap<String, List<String>> linkedHashMap;
        IndexSearcher indexSearcher = null;
        try {
            LinkedHashMap<String, List<String>> suggestions = new LinkedHashMap<String, List<String>>();
            float scoresThreshold = searchContext.getScoresThreshold();
            if (scoresThreshold == 0.0f) {
                scoresThreshold = 0.5f;
            }
            indexSearcher = LuceneHelperUtil.getIndexSearcher(searchContext.getCompanyId());
            ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>();
            if (indexSearcher.maxDoc() > 0) {
                ReaderUtil.gatherSubReaders(indexReaders, (IndexReader)indexSearcher.getIndexReader());
            }
            Iterator<String> iterator = keywords.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    linkedHashMap = suggestions;
                    break;
                }
                String keyword = iterator.next();
                List<Object> suggestionsList = Collections.emptyList();
                if (!SpellCheckerUtil.isValidWord(localizedFieldName, keyword, indexReaders)) {
                    int frequency = indexSearcher.docFreq(new Term(localizedFieldName, keyword));
                    String[] suggestionsArray = null;
                    if (frequency > 0) {
                        suggestionsArray = new String[]{keyword};
                    } else {
                        BooleanQuery suggestWordQuery = this.buildSpellCheckQuery(searchContext.getGroupIds(), keyword, languageId, "spellChecker", 0);
                        StringDistanceRelevancyChecker relevancyChecker = new StringDistanceRelevancyChecker(keyword, scoresThreshold, this._stringDistance);
                        suggestionsArray = this.search(indexSearcher, (Query)suggestWordQuery, localizedFieldName, relevancyChecker, max);
                    }
                    suggestionsList = Arrays.asList(suggestionsArray);
                }
                suggestions.put(keyword, suggestionsList);
            }
        }
        catch (IOException ioe) {
            try {
                throw new SearchException("Unable to find suggestions", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                try {
                    LuceneHelperUtil.releaseIndexSearcher(searchContext.getCompanyId(), indexSearcher);
                    throw throwable;
                }
                catch (IOException ioe2) {
                    _log.error((Object)"Unable to release searcher", (Throwable)ioe2);
                }
                throw throwable;
            }
        }
        try {
            LuceneHelperUtil.releaseIndexSearcher(searchContext.getCompanyId(), indexSearcher);
            return linkedHashMap;
        }
        catch (IOException ioe) {
            _log.error((Object)"Unable to release searcher", (Throwable)ioe);
        }
        return linkedHashMap;
    }
}

