/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.dump;

import com.liferay.portal.search.lucene.dump.IndexCommitSerializationUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;

public class DumpIndexDeletionPolicy
implements IndexDeletionPolicy {
    private volatile IndexCommit _lastIndexCommit;
    private List<String> _segmentsFileNames = new CopyOnWriteArrayList<String>();

    public void dump(OutputStream outputStream, IndexWriter indexWriter, Lock commitLock) throws IOException {
        IndexCommit indexCommit = null;
        String segmentsFileName = null;
        commitLock.lock();
        try {
            indexWriter.commit();
            indexCommit = this._lastIndexCommit;
            segmentsFileName = indexCommit.getSegmentsFileName();
            this._segmentsFileNames.add(segmentsFileName);
        }
        finally {
            commitLock.unlock();
        }
        try {
            IndexCommitSerializationUtil.serializeIndex(indexCommit, outputStream);
        }
        finally {
            this._segmentsFileNames.remove(segmentsFileName);
        }
    }

    public long getLastGeneration() {
        return this._lastIndexCommit.getGeneration();
    }

    public void onCommit(List<? extends IndexCommit> indexCommits) {
        this._lastIndexCommit = indexCommits.get(indexCommits.size() - 1);
        int i2 = 0;
        while (i2 < indexCommits.size() - 1) {
            IndexCommit indexCommit = indexCommits.get(i2);
            if (!this._segmentsFileNames.contains(indexCommit.getSegmentsFileName())) {
                indexCommit.delete();
            }
            ++i2;
        }
    }

    public void onInit(List<? extends IndexCommit> indexCommits) {
        this.onCommit(indexCommits);
    }
}

