/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DigestAuthenticationAuthVerifier
implements AuthVerifier {
    private static final String _DIGEST_REALM = "Digest realm=\"PortalRealm\"";

    public String getAuthType() {
        return "DIGEST";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties configuration) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            HttpServletRequest request = accessControlContext.getRequest();
            long userId = PortalUtil.getDigestAuthUserId((HttpServletRequest)request);
            if (userId == 0L) {
                boolean forcedDigestAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"digest_auth");
                if (forcedDigestAuth) {
                    HttpServletResponse response = accessControlContext.getResponse();
                    long companyId = PortalInstances.getCompanyId(request);
                    String remoteAddress = request.getRemoteAddr();
                    String nonce = NonceUtil.generate(companyId, remoteAddress);
                    StringBundler sb = new StringBundler(4);
                    sb.append(_DIGEST_REALM);
                    sb.append(", nonce=\"");
                    sb.append(nonce);
                    sb.append("\"");
                    response.setHeader("WWW-Authenticate", sb.toString());
                    response.setStatus(401);
                    authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                }
                return authVerifierResult;
            }
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(userId);
            return authVerifierResult;
        }
        catch (PortalException pe) {
            throw new AuthException((Throwable)pe);
        }
        catch (SystemException se) {
            throw new AuthException((Throwable)se);
        }
    }
}

