/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.membershippolicy.BaseSiteMembershipPolicy;
import com.liferay.portal.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultSiteMembershipPolicy
extends BaseSiteMembershipPolicy {
    public static final int DELETE_INTERVAL = 100;
    private static Log _log = LogFactoryUtil.getLog(DefaultSiteMembershipPolicy.class);

    public void checkMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException, SystemException {
        if (addGroupIds != null) {
            this.checkAddUsersLimitedGroup(userIds, addGroupIds);
        }
    }

    public boolean isMembershipAllowed(long userId, long groupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLimitedToParentSiteMembers() && !GroupLocalServiceUtil.hasUserGroup((long)userId, (long)group.getParentGroupId(), (boolean)false)) {
                return false;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return true;
    }

    public void propagateMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException, SystemException {
        if (removeGroupIds != null) {
            long[] lArray = removeGroupIds;
            int n = removeGroupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long removeGroupId = lArray[n2];
                this.removeUsersFromLimitedChildrenGroups(userIds, removeGroupId);
                ++n2;
            }
        }
    }

    public void verifyPolicy(Group group) throws PortalException, SystemException {
        if (group.isLimitedToParentSiteMembers()) {
            this.verifyLimitedParentMembership(group);
        }
    }

    public void verifyPolicy(Group group, Group oldGroup, List<AssetCategory> oldAssetCategories, List<AssetTag> oldAssetTags, Map<String, Serializable> oldExpandoAttributes, UnicodeProperties oldTypeSettingsProperties) throws PortalException, SystemException {
        if (group.isLimitedToParentSiteMembers()) {
            if (group.getParentGroupId() == oldGroup.getParentGroupId() && oldGroup.isLimitedToParentSiteMembers()) {
                this.verifyPolicy(group);
            } else {
                List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
                for (Group childrenGroup : childrenGroups) {
                    this.verifyPolicy(childrenGroup);
                }
            }
        }
    }

    protected void checkAddUsersLimitedGroup(long[] userIds, long[] groupIds) throws PortalException, SystemException {
        MembershipPolicyException membershipPolicyException = null;
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLimitedToParentSiteMembers()) {
                long[] lArray2 = userIds;
                int n3 = userIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    long userId = lArray2[n4];
                    if (!GroupLocalServiceUtil.hasUserGroup((long)userId, (long)group.getParentGroupId(), (boolean)false)) {
                        if (membershipPolicyException == null) {
                            membershipPolicyException = new MembershipPolicyException(5);
                        }
                        User user = UserLocalServiceUtil.getUser((long)userId);
                        membershipPolicyException.addUser(user);
                    }
                    ++n4;
                }
                if (membershipPolicyException != null) {
                    membershipPolicyException.addGroup(group);
                }
            }
            ++n2;
        }
        if (membershipPolicyException != null) {
            throw membershipPolicyException;
        }
    }

    protected List<Group> getLimitedChildrenGroups(Group group) throws PortalException, SystemException {
        ArrayList<Group> parentGroups = new ArrayList<Group>();
        parentGroups.add(group);
        LinkedHashMap<String, Serializable> groupParams = new LinkedHashMap<String, Serializable>();
        groupParams.put("groupsTree", parentGroups);
        groupParams.put("membershipRestriction", Integer.valueOf(1));
        groupParams.put("site", Boolean.TRUE);
        List childrenGroups = GroupLocalServiceUtil.search((long)group.getCompanyId(), null, (String)"", groupParams, (int)-1, (int)-1);
        List filteredChildrenGroups = ListUtil.copy((List)childrenGroups);
        block0: for (Group childrenGroup : childrenGroups) {
            for (Group ancestorGroup : childrenGroup.getAncestors()) {
                if (ancestorGroup.getGroupId() == group.getGroupId() || ancestorGroup.isLimitedToParentSiteMembers()) continue;
                filteredChildrenGroups.remove(childrenGroup);
                continue block0;
            }
        }
        return filteredChildrenGroups;
    }

    protected void removeUsersFromLimitedChildrenGroups(long[] userIds, long groupId) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
        for (Group childrenGroup : childrenGroups) {
            if (!childrenGroup.isLimitedToParentSiteMembers()) continue;
            long[] lArray = userIds;
            int n = userIds.length;
            int n2 = 0;
            while (n2 < n) {
                long userId = lArray[n2];
                UserLocalServiceUtil.unsetGroupUsers((long)childrenGroup.getGroupId(), (long[])new long[]{userId}, null);
                ++n2;
            }
        }
    }

    protected void verifyLimitedParentMembership(Group group) throws PortalException, SystemException {
        int count = UserLocalServiceUtil.getGroupUsersCount((long)group.getGroupId());
        int pages = count / 100;
        int start = 0;
        int i2 = 0;
        while (i2 <= pages) {
            int end = start + 100;
            List users = UserLocalServiceUtil.getGroupUsers((long)group.getGroupId(), (int)start, (int)end);
            for (User user : users) {
                if (!UserLocalServiceUtil.hasGroupUser((long)group.getParentGroupId(), (long)user.getUserId())) {
                    UserLocalServiceUtil.unsetGroupUsers((long)group.getGroupId(), (long[])new long[]{user.getUserId()}, null);
                    continue;
                }
                ++start;
            }
            ++i2;
        }
    }
}

