/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;

public abstract class DoAsUserThread
extends Thread {
    private static Log _log = LogFactoryUtil.getLog(DoAsUserThread.class);
    private boolean _success;
    private long _userId;

    public DoAsUserThread(long userId) {
        this._userId = userId;
    }

    public boolean isSuccess() {
        return this._success;
    }

    @Override
    public void run() {
        try {
            try {
                PrincipalThreadLocal.setName((long)this._userId);
                User user = UserLocalServiceUtil.getUserById((long)this._userId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                this.doRun();
                this._success = true;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                PrincipalThreadLocal.setName(null);
                PermissionThreadLocal.setPermissionChecker(null);
            }
        }
        finally {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
        }
    }

    protected abstract void doRun() throws Exception;
}

