/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import com.liferay.portal.security.pwd.PasswordEncryptor;
import com.liferay.portal.util.PropsValues;

public class LegacyAlgorithmAwarePasswordEncryptor
extends BasePasswordEncryptor {
    private static Log _log = LogFactoryUtil.getLog(LegacyAlgorithmAwarePasswordEncryptor.class);
    private PasswordEncryptor _parentPasswordEncryptor;

    public String[] getSupportedAlgorithmTypes() {
        return this._parentPasswordEncryptor.getSupportedAlgorithmTypes();
    }

    public void setParentPasswordEncryptor(PasswordEncryptor defaultPasswordEncryptor) {
        this._parentPasswordEncryptor = defaultPasswordEncryptor;
    }

    @Override
    protected String doEncrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        if (Validator.isNull((String)PropsValues.PASSWORDS_ENCRYPTION_ALGORITHM_LEGACY)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping passwords upgrade scheme because passwords.encryption.algorithm.legacy is blank");
            }
            try {
                return this._parentPasswordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
            }
            catch (Exception e2) {
                StringBundler sb = new StringBundler(5);
                sb.append("Password upgrade was not successfully configured. ");
                sb.append("Please set the property ");
                sb.append("\"passwords.encryption.algorithm.legacy\" with ");
                sb.append("the previous password encryption algorithm and ");
                sb.append("restart.");
                throw new PwdEncryptorException(sb.toString(), (Throwable)e2);
            }
        }
        if (_log.isDebugEnabled()) {
            String message = "Using legacy detection scheme for algorithm " + algorithm + " with current password ";
            message = Validator.isNull((String)encryptedPassword) ? String.valueOf(message) + "empty" : String.valueOf(message) + "provided";
            _log.debug((Object)message);
        }
        boolean prependAlgorithm = true;
        if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) != '{') {
            algorithm = PropsValues.PASSWORDS_ENCRYPTION_ALGORITHM_LEGACY;
            prependAlgorithm = false;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using legacy algorithm " + algorithm));
            }
        } else if (Validator.isNotNull((String)encryptedPassword) && encryptedPassword.charAt(0) == '{') {
            int index = encryptedPassword.indexOf(125);
            if (index > 0) {
                algorithm = encryptedPassword.substring(1, index);
                encryptedPassword = encryptedPassword.substring(index + 1);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Upgraded password to use algorithm " + algorithm));
            }
        }
        String newEncryptedPassword = this._parentPasswordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
        if (!prependAlgorithm) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Generated password without algorithm prefix using " + algorithm));
            }
            return newEncryptedPassword;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Generated password with algorithm prefix using " + algorithm));
        }
        StringBundler sb = new StringBundler(4);
        sb.append("{");
        sb.append(this.getAlgorithmName(algorithm));
        sb.append("}");
        sb.append(newEncryptedPassword);
        return sb.toString();
    }

    protected String getAlgorithmName(String algorithm) {
        int index = algorithm.indexOf(47);
        if (index > 0) {
            return algorithm.substring(0, index);
        }
        return algorithm;
    }
}

