/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import com.liferay.portal.security.pwd.PasswordEncryptor;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SSHAPasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"SSHA"};
    }

    @Override
    protected String doEncrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = this.getSaltBytes(encryptedPassword);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] plainTextPasswordBytes = plainTextPassword.getBytes("UTF-8");
            byte[] messageDigestBytes = messageDigest.digest(ArrayUtil.append((byte[][])new byte[][]{plainTextPasswordBytes, saltBytes}));
            return Base64.encode((byte[])ArrayUtil.append((byte[][])new byte[][]{messageDigestBytes, saltBytes}));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PwdEncryptorException(nsae.getMessage(), (Throwable)nsae);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PwdEncryptorException(uee.getMessage(), (Throwable)uee);
        }
    }

    protected byte[] getSaltBytes(String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = new byte[8];
        if (Validator.isNull((String)encryptedPassword)) {
            BigEndianCodec.putLong((byte[])saltBytes, (int)0, (long)SecureRandomUtil.nextLong());
        } else {
            try {
                byte[] encryptedPasswordBytes = Base64.decode((String)encryptedPassword);
                System.arraycopy(encryptedPasswordBytes, encryptedPasswordBytes.length - 8, saltBytes, 0, saltBytes.length);
            }
            catch (Exception e2) {
                throw new PwdEncryptorException("Unable to extract salt from encrypted password " + e2.getMessage(), (Throwable)e2);
            }
        }
        return saltBytes;
    }
}

